/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import org.eclipse.hyades.test.common.runner.CommonRunnerResourceBundle;
import org.eclipse.osgi.util.NLS;

/**
 * Event annotation.  An annotation can be a file or byte array.
 * <p>
 * 
 * 
 * @author      Joseph P. Toomey
 * @author      Paul E. Slauenwhite
 * @version     February 2, 2007
 * @since       March 31, 2006
 */
public class EventAnnotation {

	private String fileName = null;
	private String type = null;
	private byte[] contents = null;
	private File file = null;
	
	/**
	 * @return Returns the fileName.
	 */
	public String getFileName() {
		return fileName;
	}
	/**
	 * @param fileName The fileName to set.
	 */
	public void setFileName(String fileName) {
		
		if (fileName != null){
			
			this.fileName = fileName;

			file  = new File(fileName);
		}
	}
	/**
	 * @return Returns the type.
	 */
	public String getType() {
		return type;
	}
	/**
	 * @param type The type to set.
	 */
	public void setType(String type) {
		this.type = type;
	}
	/**
	 * @return Returns the contents.
	 */
	public byte[] getContents() throws IOException {
		
		if ((contents == null) && (file != null)){
			
			long fileSize = file.length();
			
			if((file.exists()) && (fileSize > 0)){

				if (fileSize > Integer.MAX_VALUE){
					throw new IOException(NLS.bind(CommonRunnerResourceBundle.EVENT_ANNOTATION_TOO_LARGE_EXC_, file.getAbsolutePath()));
				}
				
				byte[] byteArray = new byte[((int)(fileSize))];
	
				//Read the file and return its contents:
				FileInputStream fileInputStream = new FileInputStream(file);
				fileInputStream.read(byteArray);
				fileInputStream.close();
				
				return byteArray;
			}
		}
			
		return contents;
	}
	/**
	 * @param contents The contents to set.
	 */
	public void setContents(byte[] contents) {
		this.contents = contents;
	}
	
	public File getFile() {
		return file;
	}
	
	public void setFile(File file) {
				
		if (file != null){
		
			this.file = file;
			
			fileName = file.getName();
		}
	}
}
