/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IEventConstants.java,v 1.2 2005/02/25 22:17:53 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

/**
 * Common place for constants used across all event types
 * @author akmathur
 *
 */
public interface IEventConstants {
	public final static int NOT_INITIALIZED_VALUE = -100;
	public static final String ROOT_PARENT = "ROOT";

	/** The following constants are used by the 'conflict' field of the 
	 * ExecutionEvent class. This helps edcide what to do in the loader
	 * when we get a duplicate event.
	 */
	/** Just insert this event in the execution history - No Conflict determination needed **/
	public static final int CONFLICT_NONE = 0;
	/** If an event with IDs exist, then ignore this event **/
	public static final int CONFLICT_IGNORE = 1;
	/** If this event already exists, just overwrite it with the current event **/
	public static final int CONFLICT_OVERWRITE = 2;
	/** Overwrite an existing event if this event is an earlier one **/
	public static final int CONFLICT_OVERWRITE_IF_EARLIEST = 3;
	/** Overwrite an existing event if this event is the later one **/
	public static final int CONFLICT_OVERWRITE_IF_LATEST = 4;
	
}
