/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitInvocationEvent.java,v 1.3 2007/05/02 19:36:28 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.event;

import org.eclipse.hyades.test.common.util.XMLUtil;

public class JUnitInvocationEvent extends InvocationEvent {

	private String className;

	/**
	 * @return Returns the className.
	 */
	public String getClassName() {
		return className;
	}

	/**
	 * @param className The className to set.
	 */
	public void setClassName(String className) {
		this.className = className;
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot()
	{
		return "junitInvocationEvent";
	}

	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#addXMLAttributes(java.lang.StringBuffer)
	 */
	protected void addXMLAttributes(StringBuffer xml)
	{
		super.addXMLAttributes(xml);
		
		if(getClassName() != null)
			xml.append((XMLUtil.createXMLAttribute("className", getClassName(), false)).toString());
	}
	
}
