/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MessageEvent.java,v 1.2 2005/02/25 22:17:53 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

import org.eclipse.hyades.test.common.util.XMLUtil;


/**
 * This is a flat class packaged in the execution environment and
 * it mirrors the 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFMessageEvent}.
 * 
 * @author kobylin
 * @author marcelop
 */
public class MessageEvent 
extends ExecutionEvent
{
	public static final int INFO = 0;
	public static final int ERROR = 1;
	public static final int WARNING = 2;

	private int severity = NOT_INITIALIZED_VALUE;

	/**
	 * Sets the severity of this event.
	 * @param value
	 */
	public void setSeverity(int value)
	{
		severity = value;
	}

	/**
	 * Returns the severity of this event.
	 * @return int
	 */
	public int getSeverity()
	{
		return severity;
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot()
	{
		return "messageEvent";
	}

	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#addXMLAttributes(java.lang.StringBuffer)
	 */
	protected void addXMLAttributes(StringBuffer xml)
	{
		super.addXMLAttributes(xml);
		
		if(getSeverity() != NOT_INITIALIZED_VALUE)
			xml.append((XMLUtil.createXMLAttribute("severity", Integer.toString(getSeverity()), false)).toString());
	}	
}
