/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultTestArbiter.java,v 1.2 2005/02/25 22:17:53 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.junit;

import java.util.Collection;

import junit.framework.TestSuite;

import org.eclipse.hyades.test.common.event.VerdictEvent;

/**
 * Default implementation of the 
 * {@link org.eclipse.hyades.test.java.junit.IHyadesTestArbiter}.
 * 
 * @author marcelop
 * @since 1.0.1
 */
public class DefaultTestArbiter 
implements IHyadesTestArbiter
{
	public final static DefaultTestArbiter INSTANCE = new DefaultTestArbiter();
	
	/**
	 * @see org.eclipse.hyades.test.java.junit.IHyadesTestArbiter#analyse(junit.framework.TestSuite, java.util.Collection, java.util.Collection, java.util.Collection)
	 */
	public VerdictEvent analyse(TestSuite testSuite, Collection successes, Collection errors, 
		Collection failures, String errorCauses, String failureCauses)
	{
		VerdictEvent verdictEvent = new VerdictEvent();
		verdictEvent.setOwnerId(HyadesTestUtil.getHierarchyIds(testSuite));

		if(!errors.isEmpty())
		{
			verdictEvent.setVerdict(VerdictEvent.VERDICT_ERROR);
			verdictEvent.setCausedBy(errorCauses);
		}
		else if(!failures.isEmpty())
		{
			verdictEvent.setVerdict(VerdictEvent.VERDICT_FAIL);
			verdictEvent.setCausedBy(failureCauses);
		}
		else
			verdictEvent.setVerdict(VerdictEvent.VERDICT_PASS);
		
		return verdictEvent;
	}
}
