/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesTestResult.java,v 1.5 2010/02/11 15:27:35 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.junit;

import java.util.Iterator;
import java.util.List;

import junit.framework.TestListener;
import junit.framework.TestResult;

/**
 * <p>Extension of the JUnit {@link TestResult}.</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version February 11, 2010
 * @since   March 9, 2006
 * @see     TestResult
 */
public class HyadesTestResult extends TestResult {

	/**
	 * Informs the registered test listeners ({@link HyadesTestRunner} instances) that the 
	 * thread will run an asynchronous child of the current test.
	 * 
	 * @param thread The thread that will run an asynchronous child of the current test.
	 * @see #getTestListeners()
	 * @see HyadesTestRunner
	 */
	public void seedThread(Thread thread) {
		
		Iterator<TestListener> testListenersIterator = getTestListeners().iterator();
		
		while(testListenersIterator.hasNext()){

			TestListener testListener = testListenersIterator.next();
			
			if (testListener instanceof HyadesTestRunner) {
				((HyadesTestRunner)(testListener))._seedParentStack(thread);
			}
		}		
	}
	
	/**
	 * Resolves the list of registered test listeners.
	 * 
	 * @return List of registered test listeners.
	 * @see TestListener
	 * @see #addListener(TestListener)
	 */
	public List<TestListener> getTestListeners(){
		return (this.fListeners);
	}
}
