/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentConsoleStream.java,v 1.1 2007/08/22 20:23:56 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.runner.internal.util;

import java.io.OutputStream;

import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.MessageEvent;

/**
 * This class provides an output stream that can be used to override standard out and error.
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Richard K. Duggan
 * @version August 22, 2007
 * @since   August 22, 2007
 */
public class AgentConsoleStream extends OutputStream {
	
	//Agent to log the message:
	private RemoteComponentSkeleton agent = null;

	//The type of this stream:
	private int mode = -1;

	//Owner ID:
	private String ownerId = null;

	//Parent ID:
	private String parentId = null;

	//Buffer to append stream output until a new line character found:
	private StringBuffer buffer;
	
	//The types of supported streams:
	public static final int OUT = 0;
	public static final int ERR = 1;

	public AgentConsoleStream(RemoteComponentSkeleton agent, int mode, String ownerId){
		this(agent, mode, ownerId, null);	
	}

	public AgentConsoleStream(RemoteComponentSkeleton agent, int mode, String ownerId, String parentId){
		
		this.agent = agent;
		this.mode = mode;
		this.ownerId = ownerId;
		this.parentId = parentId;
		
		this.buffer = new StringBuffer();			
	}

	/**
	 * @see java.io.OutputStream#write(int)
	 */
	public void write(int b){
		
		buffer.append((char)b);
		
		if(b == '\n'){
			flush();
		}
	}
	
	/**
	 * @see java.io.OutputStream#flush()
	 */
	public void flush(){
		
		if (buffer.length() > 0){
			
			MessageEvent messageEvent = new MessageEvent();
			messageEvent.setOwnerId(ownerId);
			
			if(parentId != null){
				messageEvent.setParentId(parentId);
			}
			else{
				messageEvent.setParentId(ExecutionEvent.ROOT_PARENT);
			}

			if (mode == OUT){
				
				messageEvent.setSeverity(MessageEvent.INFO);
				messageEvent.setText("System.out:\n" + buffer.toString()); //$NON-NLS-1$
			}
			else if (mode == ERR){
				
				messageEvent.setSeverity(MessageEvent.ERROR);
				messageEvent.setText("System.err:\n" + buffer.toString()); //$NON-NLS-1$
			}
			else{
				
				messageEvent.setSeverity(MessageEvent.INFO);
				messageEvent.setText(buffer.toString());				
			}

			//Log the message event:
			agent.logMessageUTF8(messageEvent.toString());

			//Reinitialize the buffer:
			buffer = new StringBuffer();
		}
	}
}