/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Action.java,v 1.1 2007/12/05 20:02:59 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.runner.model;

/**
 * Action event.
 * <p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version April 27, 2007
 * @since   October 10, 2005
 */
public abstract class Action extends NamedElement
{
	private IActionOwner owner = null;
	private boolean synchronous = true;
	
	public void dispose()
	{
		owner = null;
		super.dispose();
	}

	
	public void setOwner(IActionOwner newOwner)
	{
		if(owner != null){
			owner.getActions().remove(this);
		}
			
		owner = newOwner;
		
		if(owner != null){
			owner.getActions().add(this);
		}
	}
	
	public IActionOwner getOwner()
	{
		return owner;
	}
	
	public boolean isSynchronous() {
		return synchronous;
	}

	public boolean isAsychronous() {
		return (!synchronous);
	}

	public void setSynchronous(boolean synchronous)
	{
		this.synchronous = synchronous;
	}
}
