/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Loop.java,v 1.1 2007/12/05 20:02:58 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.runner.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Loop event.
 * <p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version April 27, 2007
 * @since   October 10, 2005
 */
public class Loop extends Action implements IActionOwner
{
	private List actions = null;
	private int iterations = 0;
	
	public void dispose()
	{
		if(actions != null){
			actions.clear();
		}
		
		super.dispose();
	}
	
	public List getActions()
	{
		if(actions == null){
			actions = new ArrayList();
		}
		
		return actions;
	}

	public int getIterations()
	{
		return iterations;
	}

	public void setIterations(int iteractions)
	{
		this.iterations = iteractions;
	}
		
	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		
		StringBuffer buffer = new StringBuffer(super.toString().trim());
		buffer.append(" (");
		buffer.append(getIterations());
		buffer.append(".");
		
		if(getIterations() > 0){
			buffer.append(getIteration());
		}
		else{
			buffer.append(0);
		}
		
		buffer.append(")");
		
		return (buffer.toString());
	}
}
