/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuite.java,v 1.2 2007/12/07 20:44:58 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.runner.model;

import java.util.ArrayList;
import java.util.List;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestSuite
extends Test implements IActionOwner
{
	private List testCases;
	private String location;
	private TestInvocation testInvocation;

	private List actions;
	
	/**
	 * @see org.eclipse.hyades.test.common.runner.model.NamedElement#dispose()
	 */
	public void dispose()
	{
		if(testCases != null)
			testCases.clear();

		if(actions != null)
			actions.clear();
		
		super.dispose();
	}

	
	public List getActions()
	{
		if(actions == null)
			actions = new ArrayList();
		return actions;
	}	
	
	public List getTestCases()
	{
		if(testCases == null)
			testCases = new ArrayList();
		return testCases;
	}
	
	public String getLocation()
	{
		return location;
	}

	public void setLocation(String location)
	{
		this.location = location;
	}
	
	public void setTestInvocation(TestInvocation testInvocation)
	{
		this.testInvocation = testInvocation;
	}
	
	public TestInvocation getTestInvocation()
	{
		return testInvocation;
	}
}
