/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Arbiter.java,v 1.1 2007/12/05 20:02:56 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.runner.model.util;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.common.runner.model.TestCase;
import org.eclipse.hyades.test.common.runner.model.TestInvocation;
import org.eclipse.hyades.test.common.runner.model.TestSuite;

/**
 * Verdict arbiter.
 * <p>
 * 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version May 2, 2007
 * @since   1.0.2
 */
public class Arbiter
{
	public VerdictEvent analyse(TestInvocation testInvocation)
	{
		if(testInvocation.getTest() instanceof TestCase)
			return testInvocation.getVerdictEvent();

		Collection executedTestInvocations = ModelUtil.DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations();		
		TestSuite testSuite = (TestSuite)testInvocation.getTest();
		int verdict = VerdictEvent.NOT_INITIALIZED_VALUE;
		if(executedTestInvocations != null)
		{
			for (Iterator i = executedTestInvocations.iterator(); i.hasNext();)
			{
				TestInvocation ti = (TestInvocation)i.next();
				if(ModelUtil.isOwnerTestSuite(testSuite, ti))
				{
					if(ti.getVerdictEvent() == null)
						continue;
						
					int aVerdict = ti.getVerdictEvent().getVerdict();
					if(VerdictEvent.VERDICT_ERROR == aVerdict)
					{
						verdict = VerdictEvent.VERDICT_ERROR;
						break;							
					}
					else if(VerdictEvent.VERDICT_FAIL == aVerdict)
					{
						verdict = VerdictEvent.VERDICT_FAIL;
					}
					else if(VerdictEvent.VERDICT_INCONCLUSIVE == aVerdict)
					{
						if (VerdictEvent.NOT_INITIALIZED_VALUE == verdict ||
							VerdictEvent.VERDICT_PASS == verdict)
							verdict = VerdictEvent.VERDICT_INCONCLUSIVE;
					}
					else if(VerdictEvent.VERDICT_PASS == aVerdict)
					{
						if(VerdictEvent.NOT_INITIALIZED_VALUE == verdict)
							verdict = VerdictEvent.VERDICT_PASS;
					}
				}
			}
		}

		// If our verdict is still uninitialized, then we log an inconclusive verdict
		if ( verdict == VerdictEvent.NOT_INITIALIZED_VALUE ){
			verdict = VerdictEvent.VERDICT_INCONCLUSIVE;
		}

		return (ModelUtil.createVerdictEvent(testInvocation, verdict));
	}
	
	public VerdictEvent analyse()
	{
		TestSuite testSuite = ModelUtil.DEFAULT_EXECUTION_MANAGER.getRoot();
		if(testSuite == null)
			return null;

		Collection executedTestInvocations = ModelUtil.DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations();
		int verdict = VerdictEvent.NOT_INITIALIZED_VALUE;
		if(executedTestInvocations != null)
		{
			for (Iterator i = executedTestInvocations.iterator(); i.hasNext();)
			{
				TestInvocation testInvocation = (TestInvocation)i.next();
				if(testInvocation.getVerdictEvent() == null)
					continue;
					
				int aVerdict = testInvocation.getVerdictEvent().getVerdict();
				if(VerdictEvent.VERDICT_ERROR == aVerdict)
				{
					verdict = VerdictEvent.VERDICT_ERROR;
					break;							
				}
				else if(VerdictEvent.VERDICT_FAIL == aVerdict)
				{
					verdict = VerdictEvent.VERDICT_FAIL;
				}
				else if(VerdictEvent.VERDICT_INCONCLUSIVE == aVerdict)
				{
					if (VerdictEvent.NOT_INITIALIZED_VALUE == verdict ||
						VerdictEvent.VERDICT_PASS == verdict)
						verdict = VerdictEvent.VERDICT_INCONCLUSIVE;
				}
				else if(VerdictEvent.VERDICT_PASS == aVerdict)
				{
					if(VerdictEvent.NOT_INITIALIZED_VALUE == verdict)
						verdict = VerdictEvent.VERDICT_PASS;
				}
			}
		}
		
		// If our verdict is still uninitialized, then we log an inconclusive verdict
		if ( verdict == VerdictEvent.NOT_INITIALIZED_VALUE )
			verdict = VerdictEvent.VERDICT_INCONCLUSIVE;
			
		return (ModelUtil.createVerdictEvent(testSuite, verdict));
	}
}