/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: DatapoolPasswordProvider.java,v 1.3 2008/04/22 17:33:58 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.common.testservices.resources;

import java.util.HashMap;

import org.eclipse.hyades.test.common.agent.ServiceInvoker;
import org.eclipse.hyades.test.common.agent.UnconfiguredComptestAgentException;
import org.eclipse.hyades.test.common.agent.UnknownTestServiceException;

/**
 * 
 * It's the client of DatapoolPasswordsService ,used to get list of datapool and
 * it's encryption password from workbench side.
 * <p/>
 * 
 * 
 * @author      Huang Xin Ying
 * @author      Paul E. Slauenwhite
 * @version     April 22, 2008
 * @since       March 20, 2008
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public class DatapoolPasswordProvider {

	protected static final String DATAPOOL_PASSWORD_PROVIDER = "org.eclipse.hyades.test.core.DatapoolPasswordProvider";

	/**
	 * @param testId
	 * @return
	 */
	public static HashMap getDatapoolPassword(String testId)
			throws UnknownTestServiceException {
		
		if(testId != null){

			try {	
				return (parseResult(ServiceInvoker.invokeService(getProviderName(), "method=getDatapoolList,args:testId=".concat(testId))));
			} 
			catch (UnconfiguredComptestAgentException e) {
				throw new UnknownTestServiceException(e);
			}
		}
		
		return null;
	}

	/**
	 * @param result
	 * @return
	 */
	private static HashMap parseResult(String result) {
		if (result == null)
			return null;

		HashMap pr = new HashMap();
		if (result.indexOf(";") > 0) {
			String[] pairs = result.split(";");
			for (int i = 0; i < pairs.length; i++) {
				if (pairs[i].indexOf("=")>0) {
					pr.put(pairs[i].split("=")[0], pairs[i].split("=")[1]);
				}
			}
		}

		return pr;
	}

	public static String getProviderName() {
		return DATAPOOL_PASSWORD_PROVIDER;
	}
}
