/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: FilesystemResource.java,v 1.3 2008/01/11 19:30:48 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.common.testservices.resources;

/**
 * A FilesystemResource represents a file that exists within the filesystem
 * of a remote workbench machine.
 * 
 * 
 * @author  Joseph Toomey
 * @author  Paul E. Slauenwhite
 * @version January 11, 2008
 * @since   March 9, 2006
 * @provisional 
 */
public class FilesystemResource implements IRemoteResource {

	private String path;
	
	/**
	 * @param path the path to the resource no the remote file system.
	 */
	public FilesystemResource(String path) {
		super();
		this.path = path;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.common.testservices.resources.IRemoteResource#getParent()
	 */
	public IRemoteResource getParent() {
		String parentPath = null;
		int lastSep = getLastSeparatorIndex(path);
		if (lastSep != -1) {
			if (lastSep == 0) {
				// Handle / root in Linux/Unix OS
				parentPath = path.substring(0,1);
			}
			else if (lastSep > 1) {
				// If separator was found at index 0 or 1, it may be the machine 
				// name in a UNC path on windows, but we don't want to return 
				// a parent in that case.
				parentPath = path.substring(0,lastSep+1);
			}
		}
		
		if(parentPath != null){
			return new FilesystemResource(parentPath);
		}
		
		return null;
	}

	/**
	 * @param path2
	 * @return
	 */
	private int getLastSeparatorIndex(String path) {
		int winSep, unixSep, lastSep = -1;
		if (path != null && path.length() > 0) {
			winSep = path.lastIndexOf('\\');
			unixSep = path.lastIndexOf('/');
			// Find the last separator character, observing either windows
			// or linux/unix separators (since we don't know the OS of the
			// remote machine, we will consider either a valid separator)
			lastSep = ((winSep > unixSep) ? winSep : unixSep);
			// If the last separator is a trailing slash, look for the one
			// before that.
			if (lastSep == path.length() - 1)
				return getLastSeparatorIndex(path.substring(0, path.length()-1));
		}
		return lastSep;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.common.testservices.resources.IRemoteResource#getResourceName()
	 */
	public String getResourceName() {
		String name = "";
		int i = getLastSeparatorIndex(path);
		if ( i > 0 ) {
			name = path.substring(i+1, path.length());
		}
		return name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.common.testservices.resources.IRemoteResource#getFullyQualifiedRemoteResourcePath()
	 */
	public String getFullyQualifiedRemoteResourcePath() {
		return path;
	}

}
