/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: IRemoteResource.java,v 1.2 2008/01/11 19:28:22 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.common.testservices.resources;

/**
 * An IRemoteResource is a representation of a file, directory or other resource
 * which exists on a remote machine.    
 *
 * 
 * @author  Joseph Toomey
 * @author  Paul E. Slauenwhite
 * @version January 11, 2008
 * @since   March 9, 2006
 * @provisional
 */
public interface IRemoteResource {

	/**
	 * This method returns the IRemoteResource that is the parent of 
	 * this IRemoteResource or <code>null</code> if the IRemoteResource 
	 * does not have a parent.
	 * 
	 * @return The parent of this IRemoteResource or <code>null</code>.
	 */
	public IRemoteResource getParent();
	
	/**
	 * This method returns the resource name (the last segment of its path) or 
	 * an empty string if the resource does not have a name.
	 * 
	 * @return The resource name (the last segment of its path) or an empty string.
	 */
	public String getResourceName();
	
	/**
	 * This method returns the fully qualified pathname of this resource
	 * on the remote machine or an empty string if the resource does not have a 
	 * fully qualified pathname.
	 * 
	 * @return The fully qualified pathname of this resource on the remote machine or an empty string.
	 */
	public String getFullyQualifiedRemoteResourcePath();

}
