/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: RemoteResourceProviderFactory.java,v 1.3 2007/05/02 19:36:28 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.common.testservices.resources;


/**
 * This factory class provides instances of IRemoteResourceProvider 
 * implementations. 
 * 
 * @author jtoomey
 * @provisional
 */
public class RemoteResourceProviderFactory {

	private static RemoteResourceProviderFactory INSTANCE = new RemoteResourceProviderFactory();
	public static final String WORKSPACE_RESOURCE_PROVIDER = "WorkspaceResourceProvider";
	public static final String FILESYSTEM_RESOURCE_PROVIDER = "FilesystemResourceProvider";
	
	
	public static RemoteResourceProviderFactory getInstance() {
		return INSTANCE;
	}
	
	public IRemoteResourceProvider getRemoteResourceProvider(String providerID) {
		IRemoteResourceProvider provider = null;
		
		// In the future, additional remote resource providers can be added 
		// here to support different types of resources.  We currently only
		// support the WorkspaceResourceProvider.
		if (providerID.equalsIgnoreCase(WORKSPACE_RESOURCE_PROVIDER)) {
			provider = new WorkspaceResourceProvider();
		}
		else if (providerID.equalsIgnoreCase(FILESYSTEM_RESOURCE_PROVIDER)) {
			provider = new FilesystemResourceProvider();
		}
		
		return provider;
	}
	
	private RemoteResourceProviderFactory() {
		
	}
}
