/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: WorkspaceResource.java,v 1.4 2008/01/11 19:28:36 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.common.testservices.resources;


/**
 * A WorkspaceResource is a representation of a file that resides within the
 * workspace on the remote workbench's machine.
 *
 *  
 * @author  Joseph Toomey
 * @author  Paul E. Slauenwhite
 * @version January 11, 2008
 * @since   March 9, 2006
 * @provisional 
 */
public class WorkspaceResource implements IRemoteResource {

	private String project;
	private String path;
	
	/**
	 * @param project
	 * @param path
	 */
	public WorkspaceResource(String project, String path) {
		super();
		this.project = project;
		this.path = path;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.testservices.resources.IRemoteResource#getParent()
	 */
	public IRemoteResource getParent() {
		String parentPath = null;		
		if (project != null && path != null && path.length() > 0) {
			int lastSlash = path.lastIndexOf('/');
			if (lastSlash != -1) {
				parentPath = path.substring(0, lastSlash);
			}
		}
		
		if(parentPath != null){
			return (new WorkspaceResource(project, parentPath));
		}
		
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.testservices.resources.IRemoteResource#getResourceName()
	 */
	public String getResourceName() {
		String retVal = null;
		if (path == null || path.length() < 1)
			retVal = project;
		else {
			int lastSlash = path.lastIndexOf('/');
			if (lastSlash == -1 && lastSlash > path.length()) {
				retVal = path;
			}
			else {
				retVal = path.substring(lastSlash+1);
			}
		}
		return retVal;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.testservices.resources.IRemoteResource#getFullyQualifiedRemoteResourcePath()
	 */
	public String getFullyQualifiedRemoteResourcePath() {
		StringBuffer retString = new StringBuffer("");
		if ( project != null) { 
			retString.append(project);
			if (path != null && path.length() > 0) {
				retString.append("/");
				retString.append(path);
			}
		}
		return retString.toString();
	}

	/**
	 * @return the path
	 */
	String getPath() {
		return path;
	}

	/**
	 * @param path the path to set
	 */
	void setPath(String path) {
		this.path = path;
	}

	/**
	 * @return the project
	 */
	String getProject() {
		return project;
	}

	/**
	 * @param project the project to set
	 */
	void setProject(String project) {
		this.project = project;
	}

}
