/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: WorkspaceResourceProvider.java,v 1.4 2007/03/22 14:42:27 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.common.testservices.resources;


/**
 * A WorkspaceResourceProvider is a component that provides services for 
 * inspecting available resources within the workspace on a remote 
 * workbench machine, and for fetching those resources at runtime.
 *
 * @author jtoomey
 * @provisional
 */
public class WorkspaceResourceProvider extends FilesystemResourceProvider implements IRemoteResourceProvider {

	protected static final String WORKSPACE_RESOURCE_PROVIDER = "org.eclipse.hyades.test.core.WorkspaceResourceProvider";

	protected String getFileServiceName() {
		return WORKSPACE_RESOURCE_PROVIDER;
	}
	
	protected boolean isValidRemoteResourceType(IRemoteResource resource)
	{
		return (resource instanceof WorkspaceResource);
	}

	/**
	 * @return
	 */
	protected IRemoteResource getRootRemoteResource() {
		// TODO Auto-generated method stub
		return new WorkspaceResource(ROOT, null);
	}
	
	/**
	 * @param children
	 * @return
	 */
	protected IRemoteResource[] parseChildrenList(IRemoteResource parent, String children) {

		String parentProject = ((WorkspaceResource)parent).getProject();
		if (parentProject.equals(ROOT))
			parentProject = null;
		String parentPath = ((WorkspaceResource)parent).getPath();
		
		IRemoteResource[] result = {};
		String[] childArray = null;
		if (children.startsWith(CHILDREN)) {
			String childList = children.substring(CHILDREN.length());
			if (childList.length() > 0) {
				childArray = childList.split(",");
				result = new WorkspaceResource[childArray.length];
				String project = null;
				String path = null;
				
				for (int i=0; i<childArray.length; i++) {
					if (parentProject == null) {
						project = childArray[i];
						path = null;
					}
					else {
						project = parentProject;
						if (parentPath == null || parentPath.length() < 1) {
							path = childArray[i];
						}
						else {
							path = parentPath;
							if (!path.endsWith("/"))
								path += "/";
							path += childArray[i];
						}
							
					}
					result[i] = new WorkspaceResource(project, path);
				}
			}
		}
		return result;
	}

}
