/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AnnotatedMessageEvent.java,v 1.4 2007/04/19 18:17:47 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.test.common.event.provisional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.hyades.test.common.event.MessageEvent;
import org.eclipse.hyades.test.common.util.XMLUtil;

/**
 * Annotated message event.  An annotation can be a file or byte array.
 * <p>
 * 
 * 
 * @author      Mark Victory
 * @author      Paul E. Slauenwhite
 * @version     March 31, 2006
 * @since       October 7, 2005
 * @provisional As of TPTP v4.1.0, this class is marked as 'provisional'.
 * @deprecated  As of TPTP V4.2.0, use {@link MessageEvent}.
 */
public class AnnotatedMessageEvent extends MessageEvent{

	private List annotations = null;

	/**
	 * 
	 */
	public AnnotatedMessageEvent(){
		
		super();
		
		annotations = new ArrayList();
	}

	/**
	 * @return Returns the annotations.
	 */
	public List getAnnotations(){
		return annotations;
	}

	public void addAnnotation(EventAnnotation eventAnnotation){
		annotations.add(eventAnnotation);
	}

	public void clearAnnotations(){
		annotations.clear();
	}
	
	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("<").append(getXMLRoot());
		addXMLAttributes(sb);
		sb.append(">");
		addXMLProperties(sb);
		addXMLAnnotations(sb);
		sb.append("</").append(getXMLRoot());
		sb.append(">");
		
		return sb.toString();
	}
	
	/**
	 * Returns the string that is used as the tag for annotation
	 * xml fragment generated by the {@link #toString()} method.
	 * @return a not <code>null</code> String
	 */
	protected String getXMLAnnotationRoot()
	{
		return "annotation";
	}

	/**
	 * Add the annotation attributes and CDATA sections to the xml <code>StringBuffer</code> that
	 * is used by the {@link #toString()} method. 
	 * @param xml
	 */
	protected void addXMLAnnotations(StringBuffer xml) {
		Iterator iter = annotations.iterator();
		while (iter.hasNext()) {
			EventAnnotation annotation = (EventAnnotation) iter.next();
			xml.append("<").append(getXMLAnnotationRoot());
			xml.append((XMLUtil.createXMLAttribute("annotationFilename", annotation.getFileName(), false)).toString());
			xml.append((XMLUtil.createXMLAttribute("annotationType", annotation.getType(), false)).toString());
			xml.append(">");			
			try {
				byte[] contents = annotation.getContents();
				xml.append((createCDATASection(contents)));
			}
			catch ( IOException exc )
			{
				// TODO get Log infrastructure in place to allow logging of this
				exc.printStackTrace();
			}
			xml.append("</").append(getXMLAnnotationRoot()).append(">");
		}
	}
	
	/**
	 * @param base64Contents
	 * @return String
	 */
	public static StringBuffer createCDATASection(byte[] contents) {
		
		if(contents == null){
			return new StringBuffer(0);
		}
		
		return new StringBuffer("<![CDATA[").append(XMLTypeFactory.eINSTANCE.convertBase64Binary(contents)).append("]]>");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.common.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot(){
		return "annotatedMessageEvent";
	}
}
