/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventAnnotation.java,v 1.4 2007/04/19 18:17:47 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.test.common.event.provisional;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * Event annotation.  An annotation can be a file or byte array.
 * <p>
 * 
 * 
 * @author      Joseph P. Toomey
 * @author      Paul E. Slauenwhite
 * @version     March 31, 2006
 * @since       October 7, 2005
 * @provisional As of TPTP v4.1.0, this class is marked as 'provisional'.
 * @deprecated  As of TPTP V4.2.0, use {@link org.eclipse.hyades.test.common.event.EventAnnotation}.
 */
public class EventAnnotation {

	private String fileName = null;
	private String type = null;
	private byte[] contents = null;
	private File file = null;
	
	
	/**
	 * @return Returns the fileName.
	 */
	public String getFileName() {
		return fileName;
	}
	/**
	 * @param fileName The fileName to set.
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	/**
	 * @return Returns the type.
	 */
	public String getType() {
		return type;
	}
	/**
	 * @param type The type to set.
	 */
	public void setType(String type) {
		this.type = type;
	}
	/**
	 * @return Returns the contents.
	 */
	public byte[] getContents() throws IOException {
		if ( contents == null && file != null )
		{
			// Read the file and return its contents
			FileInputStream is = new FileInputStream(file);
			long size = file.length();
			if ( size > Integer.MAX_VALUE )
			{
				// TODO: when PII change is allowed, externalize this string
				throw new IOException("File too large " + file.getAbsolutePath());
			}
			byte[] data = new byte[(int)size];
			is.read(data);
			return data;
		}
		else
			return contents;
	}
	/**
	 * @param contents The contents to set.
	 */
	public void setContents(byte[] contents) {
		this.contents = contents;
	}
	
	public File getFile() {
		return file;
	}
	public void setFile(File file) {
		this.file = file;
		if ( file != null )
		{
			String fileName = file.getName();
			setFileName(fileName);
		}
	}
}
