/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SetConfig.java,v 1.27 2010/05/07 21:04:07 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.core;

import java.util.Enumeration;

import org.eclipse.tptp.platform.agentcontroller.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.config.Application;
import org.eclipse.tptp.platform.agentcontroller.config.Option;
import org.eclipse.tptp.platform.agentcontroller.config.Parameter;
import org.eclipse.tptp.platform.agentcontroller.config.PlatformObject;
import org.eclipse.tptp.platform.agentcontroller.config.PluginConfig;
import org.eclipse.tptp.platform.agentcontroller.config.SetConfigSkeleton;
import org.eclipse.tptp.platform.agentcontroller.config.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * <p>SetConfig.java</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version February 11, 2010
 * @since   February 17, 2005
 */
public class SetConfig extends SetConfigSkeleton {

	public void askUser() {
		// This method is not being used
	}

	public void generateConfiguration() {
		Document doc;
		Element holder;
		Element pConfig;

		Element app;
		Element option;
		Element param;
		Element var;

		Element agentController;
		
		//
		// Standard initializer 
		//
		doc = configFile.getDoc();
		if(doc == null) {
			return;
		}

		pConfig = doc.createElement(PluginConfig.TAG);
		holder = configFile.getHolder();
		holder.appendChild(pConfig);
		PluginConfig.setRequires(pConfig, "org.eclipse.hyades.test.core");

		//
		// Plugin specific information
		//
		agentController = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(agentController, "default");
		pConfig.appendChild(agentController);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_TEST_TOOLS_CORE");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "tools-core.jar");
		agentController.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_TEST_TOOLS_CORE");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "common.runner.jar");
		agentController.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_TEST_TOOLS_CORE");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "http.runner.jar");
		agentController.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_TEST_TOOLS_CORE");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "java.runner.jar");
		agentController.appendChild(var);

        //Add all of the NL jars to the classpath:
        Enumeration nlJars = getNLFiles();
        while(nlJars.hasMoreElements()) {
            var = doc.createElement(Variable.TAG);            
            Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_TEST_TOOLS_CORE");            
            Variable.setPosition(var, "append");            
            Variable.setValue(var, ((String)(nlJars.nextElement())));            
            agentController.appendChild(var);
        }

		app = doc.createElement(Application.TAG);
		Application.setConfiguration(app, "default");
		Application.setExecutable(app, "HyadesTestingSession");
		
		Application.setLocation(app, (PlatformObject.name.startsWith("Windows") ? "%SYS_TEMP_DIR%" : "%TMP%"));
		Application.setPath(app, "%JAVA_PATH%");
		pConfig.appendChild(app);

		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "prepend");
		/*
		 * Bug 114028 Test execution broken on z/OS
		 */
		if(PlatformObject.name.equals("z/OS") || PlatformObject.name.equals("OS/390")) {
			Parameter.setValue(param, "-Dhyades.test.JVM=%JAVA_PATH%");
		}
		else {
			Parameter.setValue(param, "-Dhyades.test.JVM=&quot;%JAVA_PATH%&quot;");
		}
		app.appendChild(param);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_EQUINOX_COMMON%");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_CORE_COMMANDS%");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_JFACE%");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_SWT%");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_EMF_COMMON%");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_EMF_ECORE%");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_EMF_ECORE_XMI%");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_HYADES_EXECUTION%");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_HYADES_LOGGING_CORE%");
		app.appendChild(var);

		/* Bug 155378 begins */
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_TPTP_PLATFORM_LOGGING_EVENTS%");
		app.appendChild(var);
		/* Bug 155378 ends */

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_HYADES_TEST_CORE%");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_HYADES_TEST_TOOLS_CORE%");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_TPTP_PLATFORM_MODELS%");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_ECLIPSE_TPTP_PLATFORM_MODELS_HIERARCHY%");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_JUNIT%");
		app.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "prepend");
		Variable.setValue(var, "%CLASSPATH_ORG_HAMCREST_CORE%");
		app.appendChild(var);
		
		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setType(option, "version");
		if(getPluginName().indexOf('_') != -1) {
			Option.setName(option, getPluginName().substring(0, getPluginName().lastIndexOf('_')));
			Option.setValue(option, getPluginName().substring(getPluginName().lastIndexOf('_') + 1));
		}
		else {
			Option.setName(option, getPluginName());
			Option.setValue(option, "unknown");
		}
		pConfig.appendChild(option);

		configFile.saveToFile();
	}

	public void printHelp() {
	}

	public void printExamples() {
	}
}
