/*******************************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CookieLinkedList.java,v 1.2 2010/05/06 18:21:58 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner;

/**
 * <p>Linked list of cookies.</p>
 * 
 * 
 * @author  Suzanne Dirkers
 * @author  Paul Slauenwhite
 * @version May 6, 2010
 * @since   August 11, 2009
 * @see     Cookie
 * @see     URILinkedList
 * @deprecated As of TPTP V4.7.0, use {@link org.eclipse.hyades.test.http.runner.internal.exec.CookieLL}.
 */
public class CookieLinkedList {

	/**
	 * The cookie.  By default, <code>null</code>.
	 */
	private Cookie cookie = null;

	/**
	 * The time (milliseconds) the cookies was stored.  By default, <code>0</code>.
	 */
	private long timeCookieStored = 0;

	/**
	 * The reference to the URI linked list.  By default, <code>null</code>.
	 */
	private URILinkedList uriLinkedList = null;

	/**
	 * <p>Creates a new cookie linked list with the default properties.</p>
	 * 
	 * <p>By default, the new cookie linked list:</p>
	 * 
	 * <ul>
	 * <li>has <code>null</code> cookie and URI linked list,</li> 
	 * <li>and has a <code>0</code> time the cookie was stored.</li> 
	 * </ul> 
	 */
	public CookieLinkedList() {
		//No-operation.
	}

	/**
	 * <p>Creates a new cookie linked list with the specified properties.</p>
	 *
	 * @param cookie The cookie, otherwise <code>null</code>.
	 * @param timeCookieStored The time (milliseconds) the cookies was stored, otherwise <code>0</code>.
	 * @param uriLinkedList The reference to the URI linked list, otherwise <code>null</code>.
	 */
	public CookieLinkedList(Cookie cookie, long timeCookieStored, URILinkedList uriLinkedList){

		this.cookie = cookie;
		this.timeCookieStored = timeCookieStored;
		this.uriLinkedList = uriLinkedList;
	}

	/**
	 * Returns the cookie.  By default, <code>null</code>.
	 * 
	 * @return The cookie, otherwise <code>null</code>.
	 */
	public Cookie getCookie() {
		return cookie;
	}

	/**
	 * Sets the cookie.  By default, <code>null</code>.
	 * 
	 * @param cookie The cookie, otherwise <code>null</code>.
	 */
	public void setCookie(Cookie cookie) {
		this.cookie = cookie;
	}

	/**
	 * Returns the time (milliseconds) the cookies was stored.  By default, <code>0</code>.
	 * 
	 * @return The time (milliseconds) the cookies was stored, otherwise <code>0</code>.
	 */
	public long getTimeCookieStored() {
		return timeCookieStored;
	}

	/**
	 * Sets the time (milliseconds) the cookies was stored.  By default, <code>0</code>.
	 * 
	 * @param timeCookieStored The time (milliseconds) the cookies was stored, otherwise <code>0</code>.
	 */
	public void setTimeCookieStored(long timeCookieStored) {
		this.timeCookieStored = timeCookieStored;
	}

	/**
	 * Returns the reference to the URI linked list.  By default, <code>null</code>.
	 * 
	 * @return The reference to the URI linked list, otherwise <code>null</code>.
	 */
	public URILinkedList getUriLinkedList() {
		return uriLinkedList;
	}

	/**
	 * Sets the reference to the URI linked list.  By default, <code>null</code>.
	 * 
	 * @param uriLinkedList The reference to the URI linked list, otherwise <code>null</code>.
	 */
	public void setUriLinkedList(URILinkedList uriLinkedList) {
		this.uriLinkedList = uriLinkedList;
	}
}
