/*******************************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DomainLinkedList.java,v 1.2 2010/05/06 18:21:58 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner;

import java.util.LinkedList;

/**
 * <p>Linked list of domains.</p>
 * 
 * 
 * @author  Suzanne Dirkers
 * @author  Paul Slauenwhite
 * @version May 6, 2010
 * @since   August 11, 2009
 * @see     Cookie
 * @deprecated As of TPTP V4.7.0, use {@link org.eclipse.hyades.test.http.runner.internal.exec.DomLL}.
 */
public class DomainLinkedList {

	/**
	 * The domain (name or IP address).  By default, <code>null</code>.
	 */
	private String domain = null;

	/**
	 * <code>true</code> if the domain of the contains an IP address.  By default, <code>false</code>.
	 */
	private boolean isDomainIPAddress = false;

	/**
	 * The number of cookies stored.  By default, <code>0</code>.
	 */
	private int numberCookiesStored = 0;

	/**
	 * The reference to the URI linked list.  By default, an empty linked list.
	 */
	private LinkedList uriLinkedList = new LinkedList();

	/**
	 * The reference to the IP host linked list.  By default, an empty linked list.
	 */
	private LinkedList ipHostLinkedList = new LinkedList();

	/**
	 * <p>Creates a new domain linked list with the default properties.</p>
	 * 
	 * <p>By default, the new domain linked list:</p>
	 * 
	 * <ul>
	 * <li>has <code>null</code> domain,</li> 
	 * <li>the domain is not an IP address,</li> 
	 * <li>has a <code>0</code> number of cookies stored,</li> 
	 * <li>and an empty URI and IP hosts linked lists.</li> 
	 * </ul> 
	 */
	public DomainLinkedList(){
		//No-operation.
	}

	/**
	 * <p>Creates a new domain linked list with the specified properties.</p>
	 *
	 * <p>In addition, empty URI and IP hosts linked lists are created.</p>
	 *
	 * @param domain The URI, otherwise <code>null</code>.
	 * @param isDomainIPAddress <code>true</code> if the domain contains an IP address, otherwise <code>false</code>.
	 * @param numberCookiesStored The number of cookies stored, otherwise <code>0</code>.
	 */
	public DomainLinkedList(String domain, boolean isDomainIPAddress, int numberCookiesStored){

		this.domain = domain;
		this.isDomainIPAddress = isDomainIPAddress;
		this.numberCookiesStored = numberCookiesStored;
	} 	

	/**
	 * Returns the domain (name or IP address).  By default, <code>null</code>.
	 *
	 * @return The URI, otherwise <code>null</code>.
	 */
	public String getDomain() {
		return domain;
	}

	/**
	 * Sets the domain (name or IP address).  By default, <code>null</code>.
	 *
	 * @param domain The URI, otherwise <code>null</code>.
	 */
	public void setDomain(String domain) {
		this.domain = domain;
	}

	/**
	 * Returns the domain of the contains an IP address.  By default, <code>false</code>.
	 *
	 * @return <code>true</code> if the domain contains an IP address, otherwise <code>false</code>.
	 */
	public boolean isDomainIPAddress() {
		return isDomainIPAddress;
	}

	/**
	 * Sets the domain of the contains an IP address.  By default, <code>false</code>. 
	 *
	 * @param isDomainIPAddress <code>true</code> if the domain contains an IP address, otherwise <code>false</code>.
	 */
	public void setDomainIPAddress(boolean isDomainIPAddress) {
		this.isDomainIPAddress = isDomainIPAddress;
	}

	/**
	 * Returns the number of cookies stored.  By default, <code>0</code>.
	 *
	 * @return The number of cookies stored, otherwise <code>0</code>.
	 */
	public int getNumberCookiesStored() {
		return numberCookiesStored;
	}

	/**
	 * Sets the number of cookies stored.  By default, <code>0</code>.
	 *
	 * @param numberCookiesStored The number of cookies stored, otherwise <code>0</code>.
	 */
	public void setNumberCookiesStored(int numberCookiesStored) {
		this.numberCookiesStored = numberCookiesStored;
	}

	/**
	 * Returns the reference to the URI linked list.  By default, an empty linked list.
	 *
	 * @return The reference to the URI linked list.
	 */
	public LinkedList getUriLinkedList() {
		return uriLinkedList;
	}

	/**
	 * Sets the reference to the URI linked list.  By default, an empty linked list.
	 *
	 * @param uriLinkedList The reference to the URI linked list.
	 */
	public void setUriLinkedList(LinkedList uriLinkedList) {
		this.uriLinkedList = uriLinkedList;
	}

	/**
	 * Returns the reference to the IP host linked list.
	 *
	 * @return The reference to the IP host linked list.
	 */
	public LinkedList getIpHostLinkedList() {
		return ipHostLinkedList;
	}

	/**
	 * Sets the reference to the IP host linked list.
	 *
	 * @param ipHostLinkedList The reference to the IP host linked list.
	 */
	public void setIpHostLinkedList(LinkedList ipHostLinkedList) {
		this.ipHostLinkedList = ipHostLinkedList;
	}
}
