/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpResourceBundle.java,v 1.4 2007/03/22 00:31:25 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.http.runner;

import org.eclipse.osgi.util.NLS;

/**
 * Runner level resource bundle.
 * <p>
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @version     March 21, 2007
 * @since       March 21, 2007
 */
public final class HttpResourceBundle extends NLS {

	private static final String BUNDLE_NAME = "org.eclipse.hyades.test.http.runner.messages";//$NON-NLS-1$

	private HttpResourceBundle() {
		// Do not instantiate
	}

	public static String COOKIES_NONAME;
	public static String COOKIES_NOHOST;
	public static String COOKIES_NOPATH;
	public static String SSL_NOTSUPPORTED;
	public static String COOKIES_EXCEPTION;
	public static String COOKIES_NOTONDOMAIN;
	public static String COOKIES_3DOTS;
	public static String COOKIES_NOVAL;
	public static String COOKIES_VERSION;
	public static String EXCEPTION_EXPIRES;

	static {
		NLS.initializeMessages(BUNDLE_NAME, HttpResourceBundle.class);
	}
}