/*******************************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: URILinkedList.java,v 1.2 2010/05/06 18:21:58 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner;

import java.util.LinkedList;

/**
 * <p>Linked list of URIs.</p>
 * 
 * 
 * @author  Suzanne Dirkers
 * @author  Paul Slauenwhite
 * @version May 6, 2010
 * @since   August 11, 2009
 * @see     Cookie
 * @see     DomainLinkedList
 * @deprecated As of TPTP V4.7.0, use {@link org.eclipse.hyades.test.http.runner.internal.exec.URILL}.
 */
public class URILinkedList {

	/**
	 * The URI path.  By default, <code>null</code>.
	 */
	private String uriPath = null;

	/**
	 * The length of the URI path.  By default, <code>0</code>.
	 */
	private int uriPathLength = 0;

	/**
	 * The reference to the domain linked list.  By default, <code>null</code>.
	 */
	private DomainLinkedList domainLinkedList = null;

	/**
	 * The reference to the cookie linked list.  By default, an empty linked list.
	 */
	private LinkedList cookieLinkedList = new LinkedList();

	/**
	 * <p>Creates a new URI linked list with the default properties.</p>
	 * 
	 * <p>By default, the new URI linked list:</p>
	 * 
	 * <ul>
	 * <li>has <code>null</code> URI path and domain linked list,</li> 
	 * <li>has a <code>0</code> URI path length,</li> 
	 * <li>and an empty cookie linked list.</li> 
	 * </ul> 
	 */
	public URILinkedList(){
		//No-operation.
	}

	/**
	 * <p>Creates a new URI linked list with the specified properties.</p>
	 * 
	 * <p>If the URI path is <code>null</code>, the length of the URI path is set to <code>0</code>.  Otherwise,
	 * the length of the URI path is set to the length of the URI path.</p>
	 *
	 * <p>In addition, an empty cookie linked list is created.</p>
	 * 
	 * @param uri The URI path, otherwise <code>null</code>.
	 * @param domainLinkedList The reference to the domain linked list, otherwise <code>null</code>.
	 */
	public URILinkedList(String uriPath, DomainLinkedList domainLinkedList){

		//Invoke the setter to set the URI path length:
		setUriPath(uriPath);

		this.domainLinkedList = domainLinkedList;
	}

	/**
	 * <p>Creates a new URI linked list with the specified properties.</p>
	 *
	 * <p>In addition, an empty cookie linked list is created.</p>
	 *
	 * @param uriPath The URI path, otherwise <code>null</code>.
	 * @param uriLength The length of the URI, otherwise <code>0</code>.
	 * @param domainLinkedList The reference to the domain linked list, otherwise <code>null</code>.
	 */
	public URILinkedList(String uriPath, int uriPathLength, DomainLinkedList domainLinkedList){

		this.uriPath = uriPath;
		this.uriPathLength = uriPathLength;
		this.domainLinkedList = domainLinkedList;
	}

	/**
	 * Returns the URI path.  By default, <code>null</code>.
	 *
	 * @return The URI path, otherwise <code>null</code>.
	 */
	public String getUriPath() {
		return uriPath;
	}

	/**
	 * <p>Sets the URI path.  By default, <code>null</code>.</p>
	 * 
	 * <p>If the URI path is <code>null</code>, the length of the URI path is set to <code>0</code>.  Otherwise,
	 * the length of the URI path is set to the length of the URI path.</p>
	 *
	 * @param uriPath The URI path, otherwise <code>null</code>.
	 */
	public void setUriPath(String uriPath) {

		this.uriPath = uriPath;

		if(uriPath != null){
			uriPathLength = uriPath.length();
		}
		else{
			uriPathLength = 0;
		}
	}

	/**
	 * Returns the length of the URI path.  By default, <code>0</code>.
	 *
	 * @return The length of the URI path, otherwise <code>0</code>.
	 */
	public int getUriPathLength() {
		return uriPathLength;
	}

	/**
	 * Sets the length of the URI path.  By default, <code>0</code>.
	 *
	 * @param uriPathLength The length of the URI path, otherwise <code>0</code>.
	 */
	public void setUriPathLength(int uriPathLength) {
		this.uriPathLength = uriPathLength;
	}

	/**
	 * Returns the reference to the domain linked list.  By default, <code>null</code>.
	 *
	 * @return The reference to the domain linked list, otherwise <code>null</code>.
	 */
	public DomainLinkedList getDomainLinkedList() {
		return domainLinkedList;
	}

	/**
	 * Sets the reference to the domain linked list.  By default, <code>null</code>.
	 *
	 * @param domainLinkedList The reference to the domain linked list, otherwise <code>null</code>.
	 */
	public void setDomainLinkedList(DomainLinkedList domainLinkedList) {
		this.domainLinkedList = domainLinkedList;
	}

	/**
	 * Returns the reference to the cookie linked list.  By default, an empty linked list.
	 *
	 * @return The reference to the cookie linked list.
	 */
	public LinkedList getCookieLinkedList() {
		return cookieLinkedList;
	}

	/**
	 * Sets the reference to the cookie linked list.  By default, an empty linked list.
	 *
	 * @param cookieLinkedList The reference to the cookie linked list.
	 */
	public void setCookieLinkedList(LinkedList cookieLinkedList) {
		this.cookieLinkedList = cookieLinkedList;
	}
}
