/*******************************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CookieLL.java,v 1.4 2010/05/06 18:22:02 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner.internal.exec;


/**
 * <p>Linked list of cookies.</p>
 * 
 * <p><b>Note</b>: This class' APIs will NOT change to maintain forward and backward compatibility.</p>
 * 
 * 
 * @author  Suzanne Dirkers
 * @author  Paul Slauenwhite
 * @version May 6, 2010
 * @since   August 11, 2009
 * @see     Cookie
 * @see     URILL
 */
public class CookieLL {

	/**
	 * The cookie.  By default, <code>null</code>.
	 */
	public Cookie thecookie = null;

	/**
	 * The time (milliseconds) the cookies was stored.  By default, <code>0</code>.
	 */
	public long time_cookie_stored = 0;

	/**
	 * The reference to the URI linked list.  By default, <code>null</code>.
	 */
	public URILL backuri = null;

	/**
	 * <p>Creates a new cookie linked list with the default properties.</p>
	 * 
	 * <p>By default, the new cookie linked list:</p>
	 * 
	 * <ul>
	 * <li>has <code>null</code> cookie and URI linked list,</li> 
	 * <li>and has a <code>0</code> time the cookie was stored.</li> 
	 * </ul> 
	 */
	public CookieLL() {
		//No-operation.
	}

	/**
	 * <p>Creates a new cookie linked list with the specified properties.</p>
	 *
	 * @param cookie The cookie, otherwise <code>null</code>.
	 * @param timeCookieStored The time (milliseconds) the cookies was stored, otherwise <code>0</code>.
	 * @param uriLinkedList The reference to the URI linked list, otherwise <code>null</code>.
	 */
	public CookieLL(Cookie cookie, long timeCookieStored, URILL uriLinkedList){

		this.thecookie = cookie;
		this.time_cookie_stored = timeCookieStored;
		this.backuri = uriLinkedList;
	}

	/**
	 * Returns the cookie.  By default, <code>null</code>.
	 * 
	 * @return The cookie, otherwise <code>null</code>.
	 */
	public Cookie getCookie() {
		return thecookie;
	}

	/**
	 * Sets the cookie.  By default, <code>null</code>.
	 * 
	 * @param cookie The cookie, otherwise <code>null</code>.
	 */
	public void setCookie(Cookie cookie) {
		this.thecookie = cookie;
	}

	/**
	 * Returns the time (milliseconds) the cookies was stored.  By default, <code>0</code>.
	 * 
	 * @return The time (milliseconds) the cookies was stored, otherwise <code>0</code>.
	 */
	public long get_time_cookie_stored() {
		return time_cookie_stored;
	}

	/**
	 * Sets the time (milliseconds) the cookies was stored.  By default, <code>0</code>.
	 * 
	 * @param timeCookieStored The time (milliseconds) the cookies was stored, otherwise <code>0</code>.
	 */
	public void set_time_cookie_stored(long timeCookieStored) {
		this.time_cookie_stored = timeCookieStored;
	}

	/**
	 * Returns the reference to the URI linked list.  By default, <code>null</code>.
	 * 
	 * @return The reference to the URI linked list, otherwise <code>null</code>.
	 */
	public URILL getbackuri() {
		return backuri;
	}

	/**
	 * Sets the reference to the URI linked list.  By default, <code>null</code>.
	 * 
	 * @param uriLinkedList The reference to the URI linked list, otherwise <code>null</code>.
	 */
	public void setbackuri(URILL uriLinkedList) {
		this.backuri = uriLinkedList;
	}
}
