/*******************************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DomLL.java,v 1.4 2010/05/06 18:22:01 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner.internal.exec;

import java.util.Iterator;
import java.util.LinkedList;


/**
 * <p>Linked list of domains.</p>
 * 
 * <p><b>Note</b>: This class' APIs will NOT change to maintain forward and backward compatibility.</p>
 * 
 * 
 * @author  Suzanne Dirkers
 * @author  Paul Slauenwhite
 * @version May 6, 2010
 * @since   August 11, 2009
 * @see     Cookie
 */
public class DomLL {

	/**
	 * The domain (name or IP address).  By default, <code>null</code>.
	 */
	public String domain = null;

	/**
	 * <code>true</code> if the domain of the contains an IP address.  By default, <code>false</code>.
	 */
	public boolean isipaddr = false;

	/**
	 * The number of cookies stored.  By default, <code>0</code>.
	 */
	public int cookies_stored = 0;

	/**
	 * The reference to the URI linked list.  By default, an empty linked list.
	 */
	public LinkedList UriLL = new LinkedList();

	/**
	 * The reference to the IP host linked list.  By default, an empty linked list.
	 */
	public LinkedList iplist = new LinkedList();

	/**
	 * <p>Creates a new domain linked list with the default properties.</p>
	 * 
	 * <p>By default, the new domain linked list:</p>
	 * 
	 * <ul>
	 * <li>has <code>null</code> domain,</li> 
	 * <li>the domain is not an IP address,</li> 
	 * <li>has a <code>0</code> number of cookies stored,</li> 
	 * <li>and an empty URI and IP hosts linked lists.</li> 
	 * </ul> 
	 */
	public DomLL(){
		//No-operation.
	}

	/**
	 * <p>Creates a new domain linked list with the specified properties.</p>
	 *
	 * <p>In addition, empty URI and IP hosts linked lists are created.</p>
	 *
	 * @param domain The URI, otherwise <code>null</code>.
	 * @param isDomainIPAddress <code>true</code> if the domain contains an IP address, otherwise <code>false</code>.
	 * @param numberCookiesStored The number of cookies stored, otherwise <code>0</code>.
	 */
	public DomLL(String domain, boolean isDomainIPAddress, int numberCookiesStored){

		this.domain = domain;
		this.isipaddr = isDomainIPAddress;
		this.cookies_stored = numberCookiesStored;
	} 	

	/**
	 * Returns the domain (name or IP address).  By default, <code>null</code>.
	 *
	 * @return The URI, otherwise <code>null</code>.
	 */
	public String getdomain() {
		return domain;
	}

	/**
	 * Sets the domain (name or IP address).  By default, <code>null</code>.
	 *
	 * @param domain The URI, otherwise <code>null</code>.
	 */
	public void setdomain(String domain) {
		this.domain = domain;
	}

	/**
	 * Returns the domain of the contains an IP address.  By default, <code>false</code>.
	 *
	 * @return <code>true</code> if the domain contains an IP address, otherwise <code>false</code>.
	 */
	public boolean getipaddr() {
		return isipaddr;
	}

	/**
	 * Sets the domain of the contains an IP address.  By default, <code>false</code>. 
	 *
	 * @param isDomainIPAddress <code>true</code> if the domain contains an IP address, otherwise <code>false</code>.
	 */
	public void setipaddr(boolean isDomainIPAddress) {
		this.isipaddr = isDomainIPAddress;
	}

	/**
	 * Returns the number of cookies stored.  By default, <code>0</code>.
	 *
	 * @return The number of cookies stored, otherwise <code>0</code>.
	 */
	public int get_cookies_stored() {
		return cookies_stored;
	}

	/**
	 * Sets the number of cookies stored.  By default, <code>0</code>.
	 *
	 * @param numberCookiesStored The number of cookies stored, otherwise <code>0</code>.
	 */
	public void set_cookies_stored(int numberCookiesStored) {
		this.cookies_stored = numberCookiesStored;
	}

	/**
	 * Returns the reference to the URI linked list.  By default, an empty linked list.
	 *
	 * @return The reference to the URI linked list.
	 */
	public LinkedList getUriLL() {
		return UriLL;
	}

	/**
	 * Adds an IP host exists to the IP host linked list. 
	 *
	 * @param ipHost The IP host.
	 */
	public void setreqhost(String ipHost) {
		iplist.add(ipHost);
	}

	/**
	 * Determines if the IP host exists in the IP host linked list.
	 *
	 * @return <code>true</code> if the IP host exists in the IP host linked list, otherwise <code>false</code>.
	 */
	public boolean findip(String ipHost) {

		if(ipHost != null){
			
			Iterator ipHostLinkedListIterator = iplist.iterator();
			
			while(ipHostLinkedListIterator.hasNext()){
				
				if (((String)(ipHostLinkedListIterator.next())).equalsIgnoreCase(ipHost)){
					return true;
				}
			}			
		}
		
		return false;
	}
}
