/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpRequestHandler.java,v 1.14 2007/05/02 19:36:25 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.http.runner.internal.exec;

import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.hyades.test.http.runner.HttpHeader;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.test.http.runner.HttpResponse;

/**
 * @author morris
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class HttpRequestHandler {
	
	// quoted strings in this source file are directly associated with HTTP Protocol
	// and must not be localized
	static final String HTTP_LINE_TERMINATOR = "\r\n";
	static final String HTTP_HEADERS_END = "\r\n\r\n";
	static final String HTTP_CONTENT_TYPE = "CONTENT-TYPE: ";
	static final String HTTP_CONTENT_LENGTH = "CONTENT-LENGTH: ";
	static final String HTTP_SET_COOKIE = "SET-COOKIE: ";
	static final String HTTP_TRANSFER_ENCODING = "TRANSFER-ENCODING: ";
	static final String HTTP_CONNECTION = "CONNECTION: ";
	static final String HTTP_CLOSE = "CLOSE";
	static final String HTTP_CHUNKED = "CHUNKED";
	static final String HTTP_HTTP = "HTTP";
	static final String HTTP_CONTENT_ENCODING = "CONTENT-ENCODING: ";

	
	

	private byte[] buffer = null;
	private int bufferSize = 0;
	/*  Need a byte array to acccumulate server response.  In order to 
	 *  set the response text, we need to accumulate all the response bytes
	 *  in one array to include multiple reads and/or chunk encoded data.
	 */
	private byte [] responseBytes = null;
	
	
	public HttpRequestHandler(){
	}
	
	public boolean sendRequest(HttpRequest request, OutputStream outputStream){
		try {
			HttpHeader[] headers = request.getHeaders();
			StringBuffer strBuf = new StringBuffer();
			strBuf.append(request.getMethod());
			strBuf.append(" ");
			strBuf.append(request.getAbsolutePath());
			strBuf.append(" HTTP/");
			strBuf.append(request.getVersion());
			strBuf.append(HTTP_LINE_TERMINATOR);

			for(int i = 0, maxi = headers.length; i < maxi; i++){
				String str = headers[i].toString();
				strBuf.append(str);
				strBuf.append(HTTP_LINE_TERMINATOR);
			}

			// add a blank line to terminate the server request
			strBuf.append(HTTP_LINE_TERMINATOR);
			outputStream.write(strBuf.toString().getBytes("UTF8"));
			// this would be POST data
			if(request.getBody() != null)
			{				
				outputStream.write(request.getBody().getBytes("UTF8"));
			}
			outputStream.flush();
		}
		catch (Exception e){
			return false;
		}
		return true;
	}

	public boolean getServerResponse(HttpRequest request, HttpResponse response, InputStream inputStream, int bufSize){
		// if the server headers include Connection: Close, then set this flag to loop until we 
		// throw a closed socket exception
		boolean bWaitForClose = false;
		int iResponseBytesPosition = 0;
		boolean bCollectServerData = false;
		int bytes_read;
		int iContentLength = 0, iResponseCode = 0, iContentSoFar = 0, iContentBegin = 0;
		int iChunkLength = -1, iThisChunkStart = 0, iTotalLength = 0, iChunkRemaining = 0;
		boolean bNeedHeaders = true;
		boolean bChunked = false;
		
		try {

			if (buffer == null || bufferSize != bufSize){
				 buffer = new byte[bufSize];
				 bufferSize = bufSize;
			}
			
			// next, we do however many reads it takes and make a determination
			// as to when the server response is completed 	
			while ((bytes_read = inputStream.read(buffer)) != -1){
				if (bNeedHeaders == true){
					String str = new String(buffer, 0, bytes_read, "UTF8");
					/* bugzilla 128613
					 * Added strMixedCase to preserve the case sensitive nature of 
					 * server response session id which is obtained by looking for set-cookie
					 * headers in getCookieHeaders method.
					 */
					String strMixedCase = new String(str);
					
					str = str.toUpperCase();
					String strRet = null;
					int iEndOfHeaders = str.indexOf(HTTP_HEADERS_END) + HTTP_HEADERS_END.length() - 1;
					bNeedHeaders = false;
					iContentBegin = iEndOfHeaders + 1;
					// the following if statement covers the case where there are no real headers
					// instead, there is HTML code indicating a 302 or whatever
					if (iEndOfHeaders > HTTP_HTTP.length()){
				
						getCookieHeaders(response, str, strMixedCase, iEndOfHeaders);
						
						strRet = getHeaderString(str, HTTP_CONTENT_LENGTH, iEndOfHeaders);
						if (strRet != null){
							strRet = strRet.trim();
							iContentLength = Integer.parseInt(strRet);
						}
						response.setContentLength(iContentLength);
							
						iResponseCode = getServerResponseCode(str);		
						response.setCode(iResponseCode);

						strRet = getHeaderString(str, HTTP_CONTENT_TYPE, iEndOfHeaders);
						response.setContentType(strRet);

						// disabling part of fix for bugzilla 139696 temporarily in order to fix 160557 separately
						// changes were made in 139696 that resulted in fixing chunk encoded server response problems seen in 160557
						/*
						if (strRet != null && strRet.indexOf("TEXT") >= 0){
							// if it is text, collect data if the response object requests it
							bCollectServerData = request.shouldCollectDetailedHTMLData();
						}
						if (request.shouldCollectAllResponseData() == true){
							// if it is not text, collect other server response data if the response object requests it
							bCollectServerData = true;
						}
						
							
						strRet = getHeaderString(str, HTTP_CONTENT_ENCODING, iEndOfHeaders);
						if (strRet != null){
							response.setContentEncoding(strRet);
						}
						*/
						
						strRet = getHeaderString(str, HTTP_CONNECTION, iEndOfHeaders);
						if (strRet != null){
							strRet = strRet.toUpperCase();
							if (strRet != null && strRet.indexOf(HTTP_CLOSE) >= 0){
								bWaitForClose = true;
								response.setShouldCloseSocket(true);
							}
						}
						strRet = getHeaderString(str, HTTP_TRANSFER_ENCODING, iEndOfHeaders);
						if (strRet != null && strRet.indexOf(HTTP_CHUNKED) >= 0){
							bChunked = true;
						}
					}
					if (bytes_read > iEndOfHeaders + 1)
						iContentSoFar = bytes_read - iEndOfHeaders - 1;
					
				}
				else {
					iChunkLength = -1;
					iContentBegin = 0;
					iContentSoFar += bytes_read;
					
				}
				if (bCollectServerData == true && iContentSoFar > 0){
					if (responseBytes == null){
						// if the content size is not given, allocate a buffer 4 times the size of the socket receive buffer
						// that was passed in, default is usually 8192 on Windows
						int responseBufSize = bufSize * 4;
						// if the content size is given, allocate a buffer for that size
						if (iContentLength > 0){
							responseBufSize = iContentLength;
						}
						responseBytes = new byte[responseBufSize];
					}else{
						// in this case, we already have a buffer, if iContentSoFar exceeds the limit of the 
						// buffer size, we need a new one and to system copy the contents from the old one.
						if (iContentSoFar >= responseBytes.length)
							responseBytes = increaseResponseBufferSize(responseBytes, iContentSoFar);
						
					}
					
				}
				if (bChunked && iContentSoFar > 0){
					String str = null;
					iTotalLength += bytes_read - iContentBegin;
					
					// see if we need to read the chunk length
					if (iChunkLength == -1 || (bytes_read > iThisChunkStart)){
						int iTokenIndex;
						// advance to next chunk or first chunk
						if (iChunkLength == -1){
							iChunkLength = 0;
							iThisChunkStart = iContentBegin;
						}
						// the following is the part of a chunk remaining from the last read
						if (iChunkRemaining > 0){
							iChunkLength = iChunkRemaining;
							iThisChunkStart = 0;
							if (bCollectServerData == true){
								int iXferbytes = iChunkLength;
								if (iXferbytes + iThisChunkStart > bytes_read)
									iXferbytes = bytes_read - iThisChunkStart;
								if (iChunkLength + iResponseBytesPosition >= responseBytes.length)
									responseBytes = increaseResponseBufferSize(responseBytes, iChunkLength + iResponseBytesPosition);										
								System.arraycopy(buffer, iThisChunkStart, responseBytes, iResponseBytesPosition, iXferbytes);
								iResponseBytesPosition += iXferbytes;
							}
							iThisChunkStart += iChunkLength;
							if (iChunkLength > bytes_read)
								iChunkRemaining = iThisChunkStart - bytes_read;
							else
								iChunkRemaining = 0;

							iThisChunkStart += + HTTP_LINE_TERMINATOR.length();
						}
						while (iThisChunkStart < bytes_read){
							
							str = new String(buffer, iThisChunkStart, bytes_read - iThisChunkStart, "UTF8");
							iTokenIndex = str.indexOf(HTTP_LINE_TERMINATOR);
							if (iTokenIndex >= 0){
								iChunkLength = 0;
								if (iTokenIndex > 0){
									String strChunkInfo = str.substring(0, iTokenIndex);
									strChunkInfo = strChunkInfo.trim();
									if (strChunkInfo.length() > 0)
										iChunkLength = Integer.parseInt(strChunkInfo, 16);
								}
							iThisChunkStart += iTokenIndex + HTTP_LINE_TERMINATOR.length();
							if (iChunkLength > 0){
									if (bCollectServerData == true){
										int iXferbytes = iChunkLength;
										if (iXferbytes + iThisChunkStart > bytes_read)
											iXferbytes = bytes_read - iThisChunkStart;
										if (iChunkLength + iResponseBytesPosition >= responseBytes.length)
											responseBytes = increaseResponseBufferSize(responseBytes, iChunkLength + iResponseBytesPosition);										
										System.arraycopy(buffer, iThisChunkStart, responseBytes, iResponseBytesPosition, iXferbytes);
										iResponseBytesPosition += iXferbytes;
									}
									iChunkLength += HTTP_LINE_TERMINATOR.length();
								}
								// now adjust to skip the data and set to the start of the next chunk
								iThisChunkStart += iChunkLength;
								// if a zero chunk length is reached, we are done
								if (iChunkLength == 0 || iThisChunkStart == bytes_read){
									iChunkRemaining = 0;
									break;
								}
								if (iThisChunkStart > bytes_read){
									iChunkRemaining = iThisChunkStart - bytes_read - HTTP_LINE_TERMINATOR.length();
									break;
								}else{
									iChunkRemaining = 0;
								}
							}
						}
					}
				}else{
					// the data is not chunked
					if (bCollectServerData == true  && iContentSoFar > 0){
						System.arraycopy(buffer, iContentBegin, responseBytes, iResponseBytesPosition, bytes_read - iContentBegin);
						iResponseBytesPosition = iContentSoFar;
					}
					
				}
				if (bChunked && iChunkLength == 0 && iChunkRemaining == 0){
					break;
				}
				if (!bChunked  && iContentSoFar >= iContentLength  && !bWaitForClose){
					break;  // server response is done
				}
				if (iResponseCode > 300 && iContentLength == 0){
					break;  // redirect or error, no further response from server expected.
				}
				if (iChunkLength == -1)
					iChunkLength = 0;
			}
		}
		catch (Exception e){
			if (!bWaitForClose){
				System.out.println(e);
				response.setCode(-1);
				response.setDetail(e.toString());
				return false;
			}
		}
		// disabling part of fix for bugzilla 139696 temporarily in order to fix 160557 separately
		// changes were made in 139696 that resulted in fixing chunk encoded server response problems seen in 160557
		
		//if (bCollectServerData == true  && iResponseBytesPosition > 0){		
			//byte [] finalBytes = shrinkResponseBuffer(responseBytes, iResponseBytesPosition);
			//response.setRawResponseData(finalBytes);
		//}
		
		return true;
	}

	private void getCookieHeaders(HttpResponse response, String str, String strMixedCase, int iEndOfHeaders){
		int iSubStart = 0, iSubEnd, index;
		String strCookie = null;
		do{
			index = str.indexOf(HTTP_SET_COOKIE, iSubStart);
			if (index >= 0 && index < iEndOfHeaders ){
				index += HTTP_SET_COOKIE.length();
				iSubEnd = str.indexOf(HTTP_LINE_TERMINATOR, index);
				strCookie = str.substring(index, iSubEnd);
				HttpHeader header = new HttpHeader();
				// do not localize this string
				header.setName("Set-Cookie");
				header.setValue(strCookie);
				response.addHeader(header);
				iSubStart = iSubEnd + 1;
			}
		}while (index >= 0  && index < iEndOfHeaders);
		return;
		
	}
		
	private String getHeaderString(String str, String strName, int iEndOfHeaders){
		String strRet = null;
		int iSubStart, iSubEnd;
		iSubStart = str.indexOf(strName);
		if (iSubStart >= 0 && iSubStart < iEndOfHeaders ){
			iSubStart += strName.length();
			iSubEnd = str.indexOf(HTTP_LINE_TERMINATOR, iSubStart);
			strRet = str.substring(iSubStart, iSubEnd);
		}
		return strRet;
	}
	private int getServerResponseCode(String str){
		int iCode = 0;
		int iSubStart, iSubEnd, iSubWhat;
		
		// confirm that the HTTP line is at the beginning of the headers
		iSubWhat = str.indexOf("HTTP");		
		if (iSubWhat >= 0 && iSubWhat <= 2 ){
			// find first blank after that
			if ((iSubStart = str.indexOf(" ", iSubWhat)) >= 0){
				// now grab the server response code
				iSubStart++;
				iSubEnd = iSubStart + 3;
				String strTemp = str.substring(iSubStart, iSubEnd);
				iCode = Integer.parseInt(strTemp);
			}
		}
		else{
			iCode = -1;
		}
		return iCode;
	}
	
	
	private byte []increaseResponseBufferSize(byte [] buf, int minSize){
		int length = buf.length;
		if (minSize > length)
			length = minSize;
		length *= 1.5;
		byte [] bigBuffer = new byte[length];
		System.arraycopy(buf, 0, bigBuffer, 0, buf.length);
		
		return bigBuffer;
		
		
	}
	
//	private byte [] shrinkResponseBuffer(byte [] buf, int iSize){
//		byte [] smallBuffer = new byte[iSize];
//		System.arraycopy(buf, 0, smallBuffer, 0, iSize);
//		return smallBuffer;
//	}
}
