/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SSLHttpExecutor.java,v 1.4 2007/05/03 01:50:45 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.http.runner.internal.exec;

import java.io.InputStream;
import java.io.OutputStream;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.test.http.runner.HttpResponse;



public class SSLHttpExecutor
{
	private String strLastHost = null;
	private int iLastPort = 0;
	private SSLSocketFactory ssf = null;	
	private SSLSocket sslSocket = null;
	private InputStream from_server = null;
	private OutputStream to_server = null;
	private HttpRequestHandler httpRequestHandler = null;
	private int socketBufSize = 0;
	

	public SSLHttpExecutor(HttpRequestHandler httpRequestHandler){
		this.httpRequestHandler = httpRequestHandler;
	}
	
	
	public HttpResponse execute(HttpRequest request, HttpResponse response)
	throws Exception
	{
		String strHost = request.getHost();
		int port = request.getPort();
		
		if (port != iLastPort || strLastHost == null ||
			strHost.regionMatches(0, strLastHost, 0, strLastHost.length()) != true ||
			sslSocket == null || sslSocket.isClosed()){
			if (connectToSecureServer(response, strHost, port)== false)
			 	return response;
		}
		
		/* In the following code, if the first attempt to send data to the server fails,
		 * connect to the server again.  If the connection fails, return, otherwise
		 * send the request on the new connection.  If that fails, give up, otherwise,
		 * proceed to get the server response.
		 */
		if (httpRequestHandler.sendRequest(request, to_server) == false){
			if (connectToSecureServer(response, strHost, port) == false){
				response.setCode(-1);
				return response; 
			}
			else
			{
				if (httpRequestHandler.sendRequest(request, to_server) == false){
					response.setCode(-1);
					return response;
				}	
			}
		}
		httpRequestHandler.getServerResponse(request, response, from_server, socketBufSize);
		if (response.getCode() == 0){
			if (connectToSecureServer(response, strHost, port) == true){
				if (httpRequestHandler.sendRequest(request, to_server) == true){
					httpRequestHandler.getServerResponse(request, response, from_server, socketBufSize);
				}
			}
		}
		
		if (response.getShouldCloseSocket() == true)
			strLastHost = null; // make sure the next request opens a new socket
		

		return response;
	}


	 private boolean connectToSecureServer(HttpResponse response, String strHost, int port)
	 {
		try{
			if (sslSocket != null) // close the existing socket, if any, before creating a new one
				sslSocket.close();
			
			if (ssf == null){  // create an SSLSocketFactory using our own X509TrustManager if we haven't already
				TrustManager[] myTM = new TrustManager [] {new PlaybackX509TrustManager() };
				SSLContext ctx = SSLContext.getInstance("SSL");
				ctx.init(null, myTM, null);
				ssf = ctx.getSocketFactory();
			}
			sslSocket = (SSLSocket)ssf.createSocket(strHost, port);
			from_server = sslSocket.getInputStream();
			to_server = sslSocket.getOutputStream();
			socketBufSize = sslSocket.getReceiveBufferSize();
			iLastPort = port;
			strLastHost = strHost;
			
		}
		catch (Exception e){
			response.setCode(-1);
			response.setDetail(e.toString());
			return false;
		}
		return true;
	}
}
