/*******************************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: URILL.java,v 1.4 2010/05/06 18:22:02 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner.internal.exec;

import java.util.LinkedList;


/**
 * <p>Linked list of URIs.</p>
 * 
 * <p><b>Note</b>: This class' APIs will NOT change to maintain forward and backward compatibility.</p>
 * 
 * 
 * @author  Suzanne Dirkers
 * @author  Paul Slauenwhite
 * @version May 6, 2010
 * @since   August 11, 2009
 * @see     Cookie
 * @see     DomLL
 */
public class URILL {

	/**
	 * The URI path.  By default, <code>null</code>.
	 */
	public String uripath = null;

	/**
	 * The length of the URI path.  By default, <code>0</code>.
	 */
	public int pathlen = 0;

	/**
	 * The reference to the domain linked list.  By default, <code>null</code>.
	 */
	public DomLL backdom = null;

	/**
	 * The reference to the cookie linked list.  By default, an empty linked list.
	 */
	public LinkedList cookieptr = new LinkedList();

	/**
	 * <p>Creates a new URI linked list with the default properties.</p>
	 * 
	 * <p>By default, the new URI linked list:</p>
	 * 
	 * <ul>
	 * <li>has <code>null</code> URI path and domain linked list,</li> 
	 * <li>has a <code>0</code> URI path length,</li> 
	 * <li>and an empty cookie linked list.</li> 
	 * </ul> 
	 */
	public URILL(){
		//No-operation.
	}

	/**
	 * <p>Creates a new URI linked list with the specified properties.</p>
	 * 
	 * <p>If the URI path is <code>null</code>, the length of the URI path is set to <code>0</code>.  Otherwise,
	 * the length of the URI path is set to the length of the URI path.</p>
	 *
	 * <p>In addition, an empty cookie linked list is created.</p>
	 * 
	 * @param uri The URI path, otherwise <code>null</code>.
	 * @param domainLinkedList The reference to the domain linked list, otherwise <code>null</code>.
	 */
	public URILL(String uriPath, DomLL domainLinkedList){

		//Invoke the setter to set the URI path length:
		seturipath(uriPath);

		this.backdom = domainLinkedList;
	}

	/**
	 * <p>Creates a new URI linked list with the specified properties.</p>
	 *
	 * <p>In addition, an empty cookie linked list is created.</p>
	 *
	 * @param uriPath The URI path, otherwise <code>null</code>.
	 * @param uriLength The length of the URI, otherwise <code>0</code>.
	 * @param domainLinkedList The reference to the domain linked list, otherwise <code>null</code>.
	 */
	public URILL(String uriPath, int uriPathLength, DomLL domainLinkedList){

		this.uripath = uriPath;
		this.pathlen = uriPathLength;
		this.backdom = domainLinkedList;
	}

	/**
	 * Returns the URI path.  By default, <code>null</code>.
	 *
	 * @return The URI path, otherwise <code>null</code>.
	 */
	public String geturipath() {
		return uripath;
	}

	/**
	 * <p>Sets the URI path.  By default, <code>null</code>.</p>
	 * 
	 * <p>If the URI path is <code>null</code>, URI path set to an empty string and the length of the 
	 * URI path is set to <code>0</code>.  Otherwise, the length of the URI path is set to the length 
	 * of the URI path.</p>
	 *
	 * @param uriPath The URI path, otherwise <code>null</code>.
	 */
	public void seturipath(String uriPath) {

		this.uripath = uriPath;

		if(uriPath == null){
			this.uripath = ""; //$NON-NLS-1$
		}
		
		pathlen = uriPath.length();
	}

	/**
	 * Returns the length of the URI path.  By default, <code>0</code>.
	 *
	 * @return The length of the URI path, otherwise <code>0</code>.
	 */
	public int getpathlen() {
		return pathlen;
	}

	/**
	 * Sets the length of the URI path.  By default, <code>0</code>.
	 *
	 * @param uriPathLength The length of the URI path, otherwise <code>0</code>.
	 */
	public void setpathlen(int uriPathLength) {
		this.pathlen = uriPathLength;
	}

	/**
	 * Returns the reference to the domain linked list.  By default, <code>null</code>.
	 *
	 * @return The reference to the domain linked list, otherwise <code>null</code>.
	 */
	public DomLL getbackdom() {
		return backdom;
	}

	/**
	 * Sets the reference to the domain linked list.  By default, <code>null</code>.
	 *
	 * @param domainLinkedList The reference to the domain linked list, otherwise <code>null</code>.
	 */
	public void setbackdom(DomLL domainLinkedList) {
		this.backdom = domainLinkedList;
	}

	/**
	 * Returns the reference to the cookie linked list.  By default, an empty linked list.
	 *
	 * @return The reference to the cookie linked list.
	 */
	public LinkedList getcookieptr() {
		return cookieptr;
	}
}
