/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpTestUtil.java,v 1.2 2005/02/25 22:17:53 hleung Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.http.runner.internal.util;

import junit.framework.Test;

import org.eclipse.hyades.test.common.junit.HyadesTestCase;
import org.eclipse.hyades.test.common.junit.HyadesTestSuite;
import org.eclipse.hyades.test.java.runner.HyadesJUnitRunner;

/**
 * @author jnevicos
 *
 * Utility class used by user generated Http Testcases
 */
public class HttpTestUtil {

	public static int getCurrentUser(HyadesTestCase testcase)
	{
		
		Test parent = testcase.getParent();
		while (parent instanceof HyadesTestSuite)
		{
			HyadesTestSuite suite = (HyadesTestSuite) parent;
			if (suite.getName().startsWith(HyadesJUnitRunner.LOADTESTSUITEPREFIX))
				return suite.getIteration() - 1;  //getIteration starts at one
			else
				parent = suite.getParent();
		}
		return 0;  //if no usergroup, then this is a single user test
 
	}

	public static int getTotalUsers(HyadesTestCase testcase)
	{		
		Test parent = testcase.getParent();
		while (parent instanceof HyadesTestSuite)
		{
			HyadesTestSuite suite = (HyadesTestSuite) parent;
			if (suite.getName().startsWith(HyadesJUnitRunner.LOADTESTSUITEPREFIX))
			{
				String tmp = suite.getName().substring(HyadesJUnitRunner.LOADTESTSUITEPREFIX.length());
				int n = 1;
				try {
					n = Integer.parseInt(tmp);
				}
				catch (NumberFormatException e) {
					n = 1;
				}
				if (n > 0)
					return n;
				else
					return 1;
			}
			else
				parent = suite.getParent(); 
		}
		return 1;  //if no usergroup, then this is a single user test
 
	}
	
}
