/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCommon.java,v 1.8 2007/12/05 20:03:02 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.common;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestCommon {
	/**
	 * The JUnit test suite type defined in the org.eclipse.hyades.test.java
	 * plugin
	 */
	public final static String JUNIT_TEST_SUITE_TYPE = "org.eclipse.hyades.test.java.junit.testSuite"; //$NON-NLS-1$

	/**
	 * The JUnit test case type defined in the org.eclipse.hyades.test.java
	 * plugin
	 */
	public final static String JUNIT_TEST_CASE_TYPE = "org.eclipse.hyades.test.java.junit.testCase"; //$NON-NLS-1$

	/**
	 * The HTTP JUnit test suite type defined in the
	 * org.eclipse.hyades.test.http plugin
	 */
	public static final String HTTP_JUNIT_TEST_SUITE_TYPE = "org.eclipse.hyades.test.http.junit.testSuite"; //$NON-NLS-1$

	/**
	 * The HTTP JUnit test case type defined in the org.eclipse.hyades.test.http
	 * plugin
	 */
	public static final String HTTP_JUNIT_TEST_CASE_TYPE = "org.eclipse.hyades.test.http.junit.testCase"; //$NON-NLS-1$

    /**
     * @deprecated As of TPTP 4.5.0, use {@link org.eclipse.tptp.test.tools.manual.util.ManualConstants.java#MANUAL_TEST_SUITE_TYPE}.
     */
	public static final String MANUAL_TEST_SUITE_TYPE = "org.eclipse.hyades.test.manual.testSuite"; //$NON-NLS-1$

    /**
     * @deprecated As of TPTP 4.5.0, use {@link org.eclipse.tptp.test.tools.manual.util.ManualConstants.java#MANUAL_TEST_CASE_TYPE}.
     */
	public static final String MANUAL_TEST_CASE_TYPE = "org.eclipse.hyades.test.manual.testCase"; //$NON-NLS-1$

    /**
     * @deprecated As of TPTP 4.4.0, use {@link org.eclipse.tptp.test.tools.junit.plugin.util.JUnitPluginConstants#PLUGIN_JUNIT_TEST_SUITE_TYPE}.
     */
    public final static String PLUGIN_JUNIT_TEST_SUITE_TYPE = "org.eclipse.hyades.test.plugin.junit.testSuite"; //$NON-NLS-1$

	public final static String OTHER_JUNIT_TEST_SUITE_TYPE = "org.eclipse.hyades.test.other.junit.testSuite"; //$NON-NLS-1$
	public final static String OTHER_JUNIT_TEST_CASE_TYPE = "org.eclipse.hyades.test.other.junit.testCase"; //$NON-NLS-1$

}
