/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCaseUniqueNameAdapter.java,v 1.4 2005/05/26 13:32:54 jcanches Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.common.util;

import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.facades.behavioral.INamedElement;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;

/**
 * @author marcelop
 * @since 1.0.1
 * @deprecated This class is not used any more. Behavior resource updates
 * is now handled by code generation.
 */
public class TestCaseUniqueNameAdapter 
extends AdapterImpl
{
	
	private boolean strictJUnitConventions;

	/**
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification msg)
	{
		if(!(msg.getNotifier() instanceof TPFTestCase))
			return;
			
		if(msg.getEventType() != Notification.SET)
			return;

		switch(msg.getFeatureID(TPFTestCase.class))
		{
			case Common_TestprofilePackage.TPF_TEST_CASE__BEHAVIOR:
			case Common_TestprofilePackage.TPF_TEST_CASE__NAME:
			case Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE:
				break;
				
			default:
				return;
		}
			
		TPFTestCase testCase = (TPFTestCase)msg.getNotifier();
		TPFBehavior behavior = testCase.getBehavior();
		if(behavior == null)
			return;
		
		if((testCase.getName() == null) || (testCase.getTestSuite() == null))
		{
			setResource(behavior, null);
			return;
		}
		
		EList testCases = testCase.getTestSuite().getTestCases();
		Helper helper = new Helper();
		
		for (Iterator i = testCases.iterator(); i.hasNext();)
		{
			TPFTestCase tc = (TPFTestCase)i.next();
			if(tc != testCase)
				setResource(tc.getBehavior(), helper.retrieveIdentifierName((INamedElement)tc, null));
		}
		
		setResource(behavior, helper.computeTestMethodName(testCase, strictJUnitConventions));
		helper.dispose();
	}
	
	protected void setResource(TPFBehavior behavior, String resource)
	{	
		if(behavior == null)
			return;
			
		if(resource == null)
		{
			if(behavior.getResource() != null)	
				behavior.setResource(null);
		}
		else if(!resource.equals(behavior.getResource()))
		{
			behavior.setResource(resource);
		}
	}
}
