/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DelegateProjectDependencyUpdater.java,v 1.3 2007/05/02 19:36:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.common.codegen;

import java.util.Collection;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * Utility dependency updater that delegates the update to a user-provided updater. Typically, a specific
 * type provider will implement this class and use it to wrap the user-provided dependency updater.
 * Mandatory dependencies can be registered in the constructor.
 * @author jcanches
 * @since 4.3
 */
public abstract class DelegateProjectDependencyUpdater implements IProjectDependencyUpdater {

	private IProjectDependencyUpdater delegate;
	
	public DelegateProjectDependencyUpdater(IProjectDependencyUpdater delegate) {
		this.delegate = delegate;
	}

	public void addRequiredPlugin(String pluginId, String jarName) {
		delegate.addRequiredPlugin(pluginId, jarName);
	}

	public void addRequiredProject(IProject project) {
		delegate.addRequiredProject(project);
	}

	public void adjustProject(IProject project, IProgressMonitor monitor) throws CoreException {
		delegate.adjustProject(project, monitor);
	}

	public Collection previewAdjustProject(IProject project) {
		return delegate.previewAdjustProject(project);
	}
	
}
