/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProjectDependencyUpdater.java,v 1.6 2007/05/02 19:36:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.common.codegen;

import java.util.Collection;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * Updates a project dependencies (usually for the purpose of updating the classpath
 * available to this project). Implementations should not perform any modification until
 * {@link #adjustProject(IProject, IProgressMonitor)} is called.
 * @author jcanches
 * @since 4.2
 */
public interface IProjectDependencyUpdater {

	/**
	 * Add to the project dependencies the specified plugin.
	 * @param pluginName The name of the required plugin.
	 * @param jarName An optional jar name. This parameter may be used as a hint
	 * by some implementations. <code>null</code> is valid and means that the complete
	 * libraries of the specified plugin should be taken into account.
	 */
	void addRequiredPlugin(String pluginId, String jarName);
	
	/**
	 * Add to the project dependencies the specified project.
	 * @param project A project.
	 */
	void addRequiredProject(IProject project);
	
	/**
	 * Performs the actual change to the specified project. This project specification
	 * is updated according to the dependencies that have been registered previously.
	 * @param project
	 * @param monitor
	 */
	void adjustProject(IProject project, IProgressMonitor monitor) throws CoreException;
	
	/**
	 * Determines which changes the call to adjustProject would make.
	 * Note for later release: the signature and semantics of this method should be changed
	 * to "Is there any change to make to the project?", so this method should return a boolean.
	 * Returning the collection of entries to added is too limiting for the implementations,
	 * and furthermore this is not a useful information since all callers to this method just
	 * test whether the returned list is empty or not.
	 * @param project
	 * @return A collection of strings indicating the dependencies that need to be added to
	 * the project. An empty list indicates that the project is already up-to-date
	 * and does not need adjusting.
	 */
	Collection previewAdjustProject(IProject project);
	
}
