/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportManager.java,v 1.4 2010/03/03 21:19:37 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.internal.common.codegen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMNode;

/**
 * <p>ImportManager.java</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul Slauenwhite
 * @version March 3, 2010
 * @since   March 18, 2005
 */
public class ImportManager{
	
	protected static HashSet javaReservedWords;

	protected static HashSet javaLangTypes;

	/**
	 * Returns a hash of all Java's keywords and textual literals, as of Java
	 * 1.4.
	 */
	public static HashSet getJavaReservedWords()
	{
		if (javaReservedWords == null)
		{
			//NOTE: Increase javaReservedWords initial capacity if adding more elements.
			javaReservedWords = new HashSet(52);
			javaReservedWords.add("abstract"); //$NON-NLS-1$
			javaReservedWords.add("assert"); //$NON-NLS-1$
			javaReservedWords.add("boolean"); //$NON-NLS-1$
			javaReservedWords.add("break"); //$NON-NLS-1$
			javaReservedWords.add("byte"); //$NON-NLS-1$
			javaReservedWords.add("case"); //$NON-NLS-1$
			javaReservedWords.add("catch"); //$NON-NLS-1$
			javaReservedWords.add("char"); //$NON-NLS-1$
			javaReservedWords.add("class"); //$NON-NLS-1$
			javaReservedWords.add("const"); //$NON-NLS-1$
			javaReservedWords.add("continue"); //$NON-NLS-1$
			javaReservedWords.add("default"); //$NON-NLS-1$
			javaReservedWords.add("do"); //$NON-NLS-1$
			javaReservedWords.add("double"); //$NON-NLS-1$
			javaReservedWords.add("else"); //$NON-NLS-1$
			javaReservedWords.add("extends"); //$NON-NLS-1$
			javaReservedWords.add("false"); //$NON-NLS-1$
			javaReservedWords.add("final"); //$NON-NLS-1$
			javaReservedWords.add("finally"); //$NON-NLS-1$
			javaReservedWords.add("float"); //$NON-NLS-1$
			javaReservedWords.add("for"); //$NON-NLS-1$
			javaReservedWords.add("goto"); //$NON-NLS-1$
			javaReservedWords.add("if"); //$NON-NLS-1$
			javaReservedWords.add("implements"); //$NON-NLS-1$
			javaReservedWords.add("import"); //$NON-NLS-1$
			javaReservedWords.add("instanceof"); //$NON-NLS-1$
			javaReservedWords.add("int"); //$NON-NLS-1$
			javaReservedWords.add("interface"); //$NON-NLS-1$
			javaReservedWords.add("long"); //$NON-NLS-1$
			javaReservedWords.add("native"); //$NON-NLS-1$
			javaReservedWords.add("new"); //$NON-NLS-1$
			javaReservedWords.add("null"); //$NON-NLS-1$
			javaReservedWords.add("package"); //$NON-NLS-1$
			javaReservedWords.add("private"); //$NON-NLS-1$
			javaReservedWords.add("protected"); //$NON-NLS-1$
			javaReservedWords.add("public"); //$NON-NLS-1$
			javaReservedWords.add("return"); //$NON-NLS-1$
			javaReservedWords.add("short"); //$NON-NLS-1$
			javaReservedWords.add("static"); //$NON-NLS-1$
			javaReservedWords.add("strictfp"); //$NON-NLS-1$
			javaReservedWords.add("super"); //$NON-NLS-1$
			javaReservedWords.add("switch"); //$NON-NLS-1$
			javaReservedWords.add("synchronized"); //$NON-NLS-1$
			javaReservedWords.add("this"); //$NON-NLS-1$
			javaReservedWords.add("throw"); //$NON-NLS-1$
			javaReservedWords.add("throws"); //$NON-NLS-1$
			javaReservedWords.add("transient"); //$NON-NLS-1$
			javaReservedWords.add("true"); //$NON-NLS-1$
			javaReservedWords.add("try"); //$NON-NLS-1$
			javaReservedWords.add("void"); //$NON-NLS-1$
			javaReservedWords.add("volatile"); //$NON-NLS-1$
			javaReservedWords.add("while"); //$NON-NLS-1$
			//NOTE: Increase javaReservedWords initial capacity if adding more elements.
		}
		return javaReservedWords;
	}

	public static HashSet getJavaLangTypes()
	{
		if (javaLangTypes == null)
		{
			//NOTE: Increase javaLangTypes initial capacity if adding more elements.
			javaLangTypes = new HashSet(85);
			javaLangTypes.add("AbstractMethodError"); //$NON-NLS-1$
			javaLangTypes.add("ArithmeticException"); //$NON-NLS-1$
			javaLangTypes.add("ArrayIndexOutOfBoundsException"); //$NON-NLS-1$
			javaLangTypes.add("ArrayStoreException"); //$NON-NLS-1$
			javaLangTypes.add("Boolean"); //$NON-NLS-1$
			javaLangTypes.add("Byte"); //$NON-NLS-1$
			javaLangTypes.add("Character"); //$NON-NLS-1$
			javaLangTypes.add("Class"); //$NON-NLS-1$
			javaLangTypes.add("ClassCastException"); //$NON-NLS-1$
			javaLangTypes.add("ClassCircularityError"); //$NON-NLS-1$
			javaLangTypes.add("ClassFormatError"); //$NON-NLS-1$
			javaLangTypes.add("ClassLoader"); //$NON-NLS-1$
			javaLangTypes.add("ClassNotFoundException"); //$NON-NLS-1$
			javaLangTypes.add("CloneNotSupportedException"); //$NON-NLS-1$
			javaLangTypes.add("Cloneable"); //$NON-NLS-1$
			javaLangTypes.add("Comparable"); //$NON-NLS-1$
			javaLangTypes.add("Compiler"); //$NON-NLS-1$
			javaLangTypes.add("Double"); //$NON-NLS-1$
			javaLangTypes.add("Error"); //$NON-NLS-1$
			javaLangTypes.add("Exception"); //$NON-NLS-1$
			javaLangTypes.add("ExceptionInInitializerError"); //$NON-NLS-1$
			javaLangTypes.add("Float"); //$NON-NLS-1$
			javaLangTypes.add("FloatingDecimal"); //$NON-NLS-1$
			javaLangTypes.add("IllegalAccessError"); //$NON-NLS-1$
			javaLangTypes.add("IllegalAccessException"); //$NON-NLS-1$
			javaLangTypes.add("IllegalArgumentException"); //$NON-NLS-1$
			javaLangTypes.add("IllegalMonitorStateException"); //$NON-NLS-1$
			javaLangTypes.add("IllegalStateException"); //$NON-NLS-1$
			javaLangTypes.add("IllegalThreadStateException"); //$NON-NLS-1$
			javaLangTypes.add("IncompatibleClassChangeError"); //$NON-NLS-1$
			javaLangTypes.add("IndexOutOfBoundsException"); //$NON-NLS-1$
			javaLangTypes.add("InheritableThreadLocal"); //$NON-NLS-1$
			javaLangTypes.add("InstantiationError"); //$NON-NLS-1$
			javaLangTypes.add("InstantiationException"); //$NON-NLS-1$
			javaLangTypes.add("Integer"); //$NON-NLS-1$
			javaLangTypes.add("InternalError"); //$NON-NLS-1$
			javaLangTypes.add("InterruptedException"); //$NON-NLS-1$
			javaLangTypes.add("LinkageError"); //$NON-NLS-1$
			javaLangTypes.add("Long"); //$NON-NLS-1$
			javaLangTypes.add("Math"); //$NON-NLS-1$
			javaLangTypes.add("NegativeArraySizeException"); //$NON-NLS-1$
			javaLangTypes.add("NoClassDefFoundError"); //$NON-NLS-1$
			javaLangTypes.add("NoSuchFieldError"); //$NON-NLS-1$
			javaLangTypes.add("NoSuchFieldException"); //$NON-NLS-1$
			javaLangTypes.add("NoSuchMethodError"); //$NON-NLS-1$
			javaLangTypes.add("NoSuchMethodException"); //$NON-NLS-1$
			javaLangTypes.add("NullPointerException"); //$NON-NLS-1$
			javaLangTypes.add("Number"); //$NON-NLS-1$
			javaLangTypes.add("NumberFormatException"); //$NON-NLS-1$
			javaLangTypes.add("Object"); //$NON-NLS-1$
			javaLangTypes.add("OutOfMemoryError"); //$NON-NLS-1$
			javaLangTypes.add("Package"); //$NON-NLS-1$
			javaLangTypes.add("Process"); //$NON-NLS-1$
			javaLangTypes.add("Runnable"); //$NON-NLS-1$
			javaLangTypes.add("Runtime"); //$NON-NLS-1$
			javaLangTypes.add("RuntimeException"); //$NON-NLS-1$
			javaLangTypes.add("RuntimePermission"); //$NON-NLS-1$
			javaLangTypes.add("SecurityException"); //$NON-NLS-1$
			javaLangTypes.add("SecurityManager"); //$NON-NLS-1$
			javaLangTypes.add("Short"); //$NON-NLS-1$
			javaLangTypes.add("StackOverflowError"); //$NON-NLS-1$
			javaLangTypes.add("String"); //$NON-NLS-1$
			javaLangTypes.add("StringBuffer"); //$NON-NLS-1$
			javaLangTypes.add("StringIndexOutOfBoundsException"); //$NON-NLS-1$
			javaLangTypes.add("System"); //$NON-NLS-1$
			javaLangTypes.add("Thread"); //$NON-NLS-1$
			javaLangTypes.add("ThreadDeath"); //$NON-NLS-1$
			javaLangTypes.add("ThreadGroup"); //$NON-NLS-1$
			javaLangTypes.add("ThreadLocal"); //$NON-NLS-1$
			javaLangTypes.add("Throwable"); //$NON-NLS-1$
			javaLangTypes.add("UnknownError"); //$NON-NLS-1$
			javaLangTypes.add("UnsatisfiedLinkError"); //$NON-NLS-1$
			javaLangTypes.add("UnsupportedClassVersionError"); //$NON-NLS-1$
			javaLangTypes.add("UnsupportedOperationException"); //$NON-NLS-1$
			javaLangTypes.add("VerifyError"); //$NON-NLS-1$
			javaLangTypes.add("VirtualMachineError"); //$NON-NLS-1$
			javaLangTypes.add("Void"); //$NON-NLS-1$
			javaLangTypes.add("boolean"); //$NON-NLS-1$
			javaLangTypes.add("byte"); //$NON-NLS-1$
			javaLangTypes.add("char"); //$NON-NLS-1$
			javaLangTypes.add("double"); //$NON-NLS-1$
			javaLangTypes.add("float"); //$NON-NLS-1$
			javaLangTypes.add("int"); //$NON-NLS-1$
			javaLangTypes.add("long"); //$NON-NLS-1$
			javaLangTypes.add("short"); //$NON-NLS-1$
			//NOTE: Increase javaLangTypes initial capacity if adding more elements.
		}
		return javaLangTypes;
	}

	protected SortedSet imports = new TreeSet();
	protected HashMap shortNameToImportMap = new HashMap();
	protected HashSet javaLangImports = null;
	protected HashSet importedPackages;

	public ImportManager(String compilationUnitPackage)
	{
		importedPackages = new HashSet();
		importedPackages.add(compilationUnitPackage);
	}

	public Collection getImports()
	{
		return imports;
	}

	public String getImportedName(String qualifiedName)
	{
		String indices = ""; //$NON-NLS-1$
		int firstBracket = qualifiedName.indexOf("["); //$NON-NLS-1$
		if (firstBracket != -1)
		{
			indices = qualifiedName.substring(firstBracket);
			qualifiedName = qualifiedName.substring(0, firstBracket);
		}

		String baseName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1); //$NON-NLS-1$

		String shortName = baseName;
		int firstDollar = shortName.indexOf("$"); //$NON-NLS-1$
		if (firstDollar != -1)
		{
			shortName = shortName.substring(0, firstDollar);
		}

		String registeredName = (String)shortNameToImportMap.get(shortName);
		if (registeredName == null)
		{
			registeredName = "java.lang." + shortName; //$NON-NLS-1$
			if (qualifiedName.equals(registeredName))
			{
				if (javaLangImports != null && javaLangImports.contains(shortName))
				{
					imports.add(qualifiedName);
				}
				return shortName + indices;
			}
			else
			{
				return qualifiedName + indices;
			}
		}
		else
		{
			if (qualifiedName.startsWith(registeredName))
			{
				if (qualifiedName.length() == registeredName.length())
				{
					return baseName.replace('$', '.') + indices;
				}
				else
				{
					char character = qualifiedName.charAt(registeredName.length());
					if (character == '.' || character == '$')
					{
						return baseName.replace('$', '.') + indices;
					}
				}
			}
			return qualifiedName.replace('$', '.') + indices;
		}
	}

	public void addImport(String packageName, String shortName)
	{
		int firstBracket = shortName.indexOf("["); //$NON-NLS-1$
		if (firstBracket != -1)
			shortName = shortName.substring(0, firstBracket);
		basicAdd(packageName, shortName, packageName + "." + shortName); //$NON-NLS-1$
	}

	public void addImport(String qualifiedName)
	{
		int firstBracket = qualifiedName.indexOf("["); //$NON-NLS-1$
		if (firstBracket != -1)
			qualifiedName = qualifiedName.substring(0, firstBracket);

		int lastDot = qualifiedName.lastIndexOf("."); //$NON-NLS-1$
		String shortName = qualifiedName.substring(lastDot + 1);
		int firstDollar = shortName.indexOf("$"); //$NON-NLS-1$
		if (firstDollar != -1)
		{
			shortName = shortName.substring(0, firstDollar);
		}

		String packageName = lastDot == -1 ? null : qualifiedName.substring(0, lastDot);
		basicAdd(packageName, shortName, qualifiedName);
	}

	public void addMasterImport(String packageName, String shortName)
	{
		shortNameToImportMap.put(shortName, packageName + "." + shortName); //$NON-NLS-1$
	}

	public void addJavaLangImports(List javaLangClassNames)
	{
		if (!javaLangClassNames.isEmpty())
		{
			javaLangImports = new HashSet();
			javaLangImports.addAll(javaLangClassNames);
		}
	}

	public boolean hasImport(String shortName)
	{
		return shortNameToImportMap.containsKey(shortName);
	}

	public void addCompilationUnitImports(String compilationUnitContents)
	{
		DOMFactory jdomFactory = new DOMFactory();
		IDOMCompilationUnit jdomCompilationUnit = jdomFactory.createCompilationUnit(compilationUnitContents, "Local"); //$NON-NLS-1$
		for (IDOMNode child = jdomCompilationUnit.getFirstChild(); child != null; child = child.getNextNode())
		{
			switch (child.getNodeType())
			{
				case IDOMNode.IMPORT :
					{
						IDOMImport jdomImport = (IDOMImport)child;
						String qualifiedName = jdomImport.getName();
						int lastDot = qualifiedName.lastIndexOf("."); //$NON-NLS-1$
						String shortName = qualifiedName.substring(lastDot + 1);
						if (shortName.equals("*")) //$NON-NLS-1$
						{
							String packageName = qualifiedName.substring(0, lastDot);
							importedPackages.add(packageName);
						}
						else
						{
							shortNameToImportMap.put(shortName, qualifiedName);
						}
						break;
					}
			}
		}
	}

	private void basicAdd(String packageName, String shortName, String qualifiedName)
	{
		if (shortName.equals("*")) //$NON-NLS-1$
		{
			importedPackages.add(packageName);
			imports.add(qualifiedName);
		}
		else if (!shortNameToImportMap.containsKey(shortName) && (!getJavaLangTypes().contains(shortName)))
		{
			shortNameToImportMap.put(shortName, qualifiedName);

			if (packageName != null && !importedPackages.contains(packageName))
			{
				imports.add(qualifiedName);
			}
		}
	}
}
