/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PluginProjectDependencyUpdater.java,v 1.1 2007/04/26 16:27:39 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.common.codegen;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.util.ManifestUtil;
import org.eclipse.hyades.test.tools.core.internal.util.PluginProjectUtil;
import org.eclipse.hyades.test.tools.core.internal.util.PluginXmlUtil;
import org.osgi.framework.Constants;

public class PluginProjectDependencyUpdater implements IProjectDependencyUpdater {

	private Collection requiredPlugins = null;
	
	public void addRequiredPlugin(String pluginId, String jarName) {
		
		if (requiredPlugins == null){
			requiredPlugins = new HashSet();
		}
		
		requiredPlugins.add(pluginId);
	}

	public void addRequiredProject(IProject project) {
		
		String id = PluginProjectUtil.getBundleSymbolicName(project);
		
		if (id != null){
			addRequiredPlugin(id, null);
		}
	}

	public void adjustProject(IProject project, IProgressMonitor monitor) throws CoreException {
		
		//Use OSGi services to modify the manifest file:
		if (PluginProjectUtil.isManifestBasedPluginProject(project)) {
			modifyManifestWithRequiredPlugins(project);
		} 
		else {
			PluginXmlUtil.addMissingRequiredPlugins(project, requiredPlugins);
		}
	}
		
	protected void modifyManifestWithRequiredPlugins(IProject pluginProject) {
		
		IFile file = ManifestUtil.getManifestFile(pluginProject);
		
		if (file.exists()) {
			
			File file_ = file.getLocation().toFile();
			
			ManifestUtil.addAttributesToManifestProperty(file_, file_, Constants.REQUIRE_BUNDLE, requiredPlugins);
			
			try {
				file.refreshLocal(0, null);
			} 
			catch (CoreException e) {
				CorePlugin.logError(e);
			}
		}
	}

	public Collection previewAdjustProject(IProject pluginProject) {
		
		HashSet result = new HashSet();
		Iterator iterator = requiredPlugins.iterator();

		while (iterator.hasNext()) {

			String pluginId = (String) iterator.next();

			if (!PluginProjectUtil.containsPluginRequires(pluginProject, pluginId)) {

				String version = PluginProjectUtil.getBundleVersion(pluginId);

				if (version != null){
					result.add(pluginId + "<" + version + ">"); //$NON-NLS-1$//$NON-NLS-2$
				} 
				else {
					result.add(pluginId);
				}
			}
		}

		return result;
	}
}
