/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AdjustSourceContainerChange.java,v 1.4 2007/05/02 19:36:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.common.codegen.changes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.hyades.test.core.internal.changes.PotentialChange;
import org.eclipse.hyades.test.tools.core.internal.common.CommonPluginMessages;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * Change that transforms a folder into a source folder.
 * @author jcanches
 * @since 4.3
 */
public class AdjustSourceContainerChange extends PotentialChange {

	private IContainer container;

	public AdjustSourceContainerChange(IContainer container) {
		this.container = container;
	}
	
	public Object getModifiedElement() {
		return container;
	}

	public String getName() {
		return NLS.bind(CommonPluginMessages.DEFINE_SOURCE_FOLDER, container.getFullPath().toString());
	}

	public void initializeValidationData(IProgressMonitor pm) {
		// NOP
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException,	OperationCanceledException {
		pm.beginTask("", 2); //$NON-NLS-1$
		try {
			RefactoringStatus status = new RefactoringStatus();
			if (!container.isAccessible()) {
				status.addFatalError(NLS.bind(CommonPluginMessages.RESOURCE_NOT_ACCESSIBLE, container.getFullPath().toString()));
			}
			pm.worked(1);
			IJavaProject javaProject = JavaCore.create(container.getProject());
			if (!javaProject.exists()) {
				status.addFatalError(NLS.bind(CommonPluginMessages.NOT_IN_JAVA_PROJECT, container.getFullPath().toString()));
			}
			pm.worked(1);
			return status;
		} finally {
			pm.done();
		}
	}

	public Change perform(IProgressMonitor monitor) throws CoreException {
		IJavaProject javaProject = JavaCore.create(container.getProject());
		if(container.getType() == IResource.FOLDER)
		{
			if(!javaProject.isOnClasspath(container))
			{
				IClasspathEntry entry = JavaCore.newSourceEntry(container.getFullPath());
				List entries = new ArrayList(Arrays.asList(javaProject.getRawClasspath()));
				entries.add(1, entry);
				javaProject.setRawClasspath((IClasspathEntry[])entries.toArray(new IClasspathEntry[entries.size()]), monitor);
			}
		}
		return null;
	}

	public boolean hasEffect() {
		IJavaProject javaProject = JavaCore.create(container.getProject());
		if(container.getType() == IResource.FOLDER)
		{
			return !javaProject.isOnClasspath(container);
		}
		return true;
	}

}
