/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AdjustTestCasePropertiesChange.java,v 1.3 2007/11/23 15:57:31 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.common.codegen.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.tools.core.internal.common.CommonPluginMessages;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class AdjustTestCasePropertiesChange extends Change {

	private ITestCase testCase;
	private String methodName;
	
	public AdjustTestCasePropertiesChange(ITestCase testCase, String methodName) {
		this.testCase = testCase;
		this.methodName = methodName;
	}
	
	public Object getModifiedElement() {
		return testCase;
	}

	public String getName() {
		return NLS.bind(CommonPluginMessages.AdjustTestCasePropertiesChange_ADJUST_METHOD_NAME_CHANGE, testCase.getName());
	}

	public void initializeValidationData(IProgressMonitor pm) {
		// NOP
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException,	OperationCanceledException {
		return new RefactoringStatus();
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		String oldName = Helper.getTestMethodName(testCase);
		Helper.setTestMethodName(testCase, methodName);
		return new AdjustTestCasePropertiesChange(testCase, oldName);
	}

}
