/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProjectAdjustChange.java,v 1.3 2007/05/02 19:36:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.common.codegen.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.hyades.test.tools.core.internal.common.CommonPluginMessages;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.IProjectDependencyUpdater;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * Change that applies a project dependency updater on a project.
 * @author jcanches
 * @since 4.3
 */
public class ProjectAdjustChange extends Change {

	private IProject project;
	private IProjectDependencyUpdater updater;
	
	public ProjectAdjustChange(IProjectDependencyUpdater updater, IProject project) {
		this.updater = updater;
		this.project = project;
	}
	
	public Object getModifiedElement() {
		return project;
	}

	public String getName() {
		return NLS.bind(CommonPluginMessages.ADJUST_CLASSPATH, project.getName());
	}

	public void initializeValidationData(IProgressMonitor pm) {
		// NOP
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		RefactoringStatus status = new RefactoringStatus();
		if (!project.isAccessible()) {
			status.addFatalError(NLS.bind(CommonPluginMessages.PROJECT_NOT_ACCESSIBLE, project.getName()));
		}
		return status;
	}

	public Change perform(IProgressMonitor monitor) throws CoreException {
		updater.adjustProject(project, monitor);
		return null;
	}

}
