/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.codegen;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;

class GenSuiteMethod
{
  protected static String nl;
  public static synchronized GenSuiteMethod create(String lineSeparator)
  {
    nl = lineSeparator;
    GenSuiteMethod result = new GenSuiteMethod();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "\t\t";
  protected final String TEXT_2 = NL + "/**" + NL + " * Returns the JUnit test suite that implements the <b>";
  protected final String TEXT_3 = "</b>" + NL + " * definition." + NL + " */" + NL + "public static ";
  protected final String TEXT_4 = " suite()" + NL + "{";
  protected final String TEXT_5 = "\t";
  protected final String TEXT_6 = " ";
  protected final String TEXT_7 = " = new ";
  protected final String TEXT_8 = "(\"";
  protected final String TEXT_9 = "\");" + NL + "\t";
  protected final String TEXT_10 = ".setArbiter(DefaultTestArbiter.INSTANCE).setId(\"";
  protected final String TEXT_11 = "\");" + NL + "\t" + NL + "\t";
  protected final String TEXT_12 = "\t";
  protected final String TEXT_13 = " ";
  protected final String TEXT_14 = " = new ";
  protected final String TEXT_15 = "(";
  protected final String TEXT_16 = ".class);";
  protected final String TEXT_17 = NL + "\treturn ";
  protected final String TEXT_18 = ";" + NL + "}" + NL;

	public String generate(ITestSuite testSuite, final Helper helper)
  {
    final StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    
	class InvocationGenerator
	{
		private String hyadesTestSuiteClassName;
		
		public InvocationGenerator(String hyadesTestSuiteClassName)
		{
			this.hyadesTestSuiteClassName = hyadesTestSuiteClassName;
		}
		
		public StringBuffer generate(String owner, List actions)
		{
			StringBuffer code = new StringBuffer();
			StringBuffer sb = new StringBuffer();
			for(Iterator i=actions.iterator(); i.hasNext();)
			{
				IAction action = (IAction)i.next();
				
				if(action instanceof ITestInvocation)
					sb = generate(owner, (ITestInvocation)action);
				else if(action instanceof ILoop)
					sb = generate(owner, (ILoop)action);
				else
					continue;

				if (sb == null)
				{ //error condition
					//code.append(NL).append("//ERROR: No definition found for test element: ").append(action.getName()).append(NL).append(NL);
					continue;	
				}					

				if(sb.length() == 0)
					continue;
				
				if(code.length() > 0)
					code.append(NL).append(NL);
				code.append(sb.toString());
			}

			return code;
		}
		
		private StringBuffer generate(String owner, ITestInvocation testInvocation)
		{
			StringBuffer sb = new StringBuffer(owner).append(".addTest(");
			ITest invokedTest = testInvocation.getInvokedTest();
			if(invokedTest == null)
				return null;
				
			boolean isHyadesTest = !invokedTest.getImplementor().isExternalImplementor();
			if(invokedTest instanceof ITestSuite)
			{
				String invokedClassName = helper.getImportedName(invokedTest.getImplementor().getResource());
				if (isHyadesTest) {
					sb.append("((").append(hyadesTestSuiteClassName).append(")").append(invokedClassName).append(".suite())");
				} else {
					helper.addImport(Helper.HYADES_JUNIT_RUNNER);
					sb.append(helper.getImportedName(Helper.HYADES_JUNIT_RUNNER)).append(".getTest(").append(invokedClassName).append(".class)");
				}
			}
			else
			{
				ITestCase testCase = (ITestCase)invokedTest;
				String identifier = helper.getTestMethodName(testCase, false);
				if (identifier == null) {
					// The behavior is invoking a TestCase from another TestSuite, but the
					// code for the foreign TestCase has not been generated yet.
					identifier = helper.computeTestMethodName(testCase, testCase.getOwner().getImplementor().isExternalImplementor());
				}

				sb.append("new ").append(helper.getImportedName(testCase.getOwner().getImplementor().getResource())).append("(\"").append(identifier).append("\")");
				if (isHyadesTest) {
					sb.append(".setId(\"").append(invokedTest.getId()).append("\")");
				}
			}
			if (isHyadesTest) {
				sb.append(".setTestInvocationId(\"").append(testInvocation.getId()).append("\")");			
				if(!testInvocation.isSynchronous())
					sb.append(".setSynchronous(false)");
			}
			
			return sb.append(");");
		}

		private StringBuffer generate(String owner, ILoop loop)
		{
			String identifier = helper.retrieveIdentifierName(loop, "METHOD");
			String name = loop.getName();
			if(name == null)
				name = "";
			else
				name = "\"" + name + "\"";
				
			StringBuffer sb = new StringBuffer(hyadesTestSuiteClassName).append(" ").append(identifier);
			sb.append(" = new ").append(hyadesTestSuiteClassName).append("(").append(name).append(");").append(NL);
			sb.append(owner).append(".addTest(new ").append(helper.getImportedName("junit.extensions.RepeatedTest")).append("(").append(identifier).append(", ").append(loop.getCondition().getConstraint()).append("));").append(NL);
			sb.append(identifier).append(".setId(\"").append(loop.getId()).append("\")");
			if(!loop.isSynchronous())
				sb.append(".setSynchronous(false)");				
			sb.append(";");
			
			return sb.append(NL).append(NL).append(generate(identifier, loop.getBlock().getActions()).toString());
		}
	}

    
	boolean isCodeBehavior = testSuite.getImplementor().isExternalImplementor();
	String testSuiteClassName;
	if (isCodeBehavior) {
		testSuiteClassName = Helper.JUNIT_TEST_SUITE_CLASS_NAME;
	} else {
		testSuiteClassName = Helper.HYADES_TEST_SUITE_CLASS_NAME;
		helper.addImport(Helper.HYADES_DEFAULT_TEST_ARBITER_CLASS_NAME);
	}
	helper.addImport(testSuiteClassName);
	helper.addImport(Helper.JUNIT_TEST_CLASS_NAME);
	testSuiteClassName = helper.getImportedName(testSuiteClassName);
	final String junitTestClassName = helper.getImportedName(Helper.JUNIT_TEST_CLASS_NAME);

    stringBuffer.append(TEXT_2);
    stringBuffer.append(testSuite.getName());
    stringBuffer.append(TEXT_3);
    stringBuffer.append(junitTestClassName);
    stringBuffer.append(TEXT_4);
    
	String javaElement = helper.retrieveIdentifierName(testSuite, "SUITE"); 

	if (!isCodeBehavior) {
		String code = new InvocationGenerator(testSuiteClassName).generate(javaElement, testSuite.getImplementor().getBlock().getActions()).toString();

    stringBuffer.append(TEXT_5);
    stringBuffer.append(testSuiteClassName);
    stringBuffer.append(TEXT_6);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_7);
    stringBuffer.append(testSuiteClassName);
    stringBuffer.append(TEXT_8);
    stringBuffer.append(testSuite.getName());
    stringBuffer.append(TEXT_9);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_10);
    stringBuffer.append(testSuite.getId());
    stringBuffer.append(TEXT_11);
    stringBuffer.append(code);
    
	} else {
		String className = helper.retrieveClassName(testSuite);

    stringBuffer.append(TEXT_12);
    stringBuffer.append(testSuiteClassName);
    stringBuffer.append(TEXT_13);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_14);
    stringBuffer.append(testSuiteClassName);
    stringBuffer.append(TEXT_15);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_16);
    
	}

    stringBuffer.append(TEXT_17);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_18);
    
    return stringBuffer.toString();
  }
}
