/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.codegen;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;
import org.eclipse.hyades.test.core.util.StringUtil;

class GenTestMethod
{
  protected static String nl;
  public static synchronized GenTestMethod create(String lineSeparator)
  {
    nl = lineSeparator;
    GenTestMethod result = new GenTestMethod();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "\t\t";
  protected final String TEXT_2 = NL + "\t/**" + NL + "\t * ";
  protected final String TEXT_3 = NL + "\t *" + NL + "\t * ";
  protected final String TEXT_4 = NL + "\t * ";
  protected final String TEXT_5 = NL + "\t * @throws ";
  protected final String TEXT_6 = NL + "\t */" + NL + "\tpublic void ";
  protected final String TEXT_7 = "()" + NL + "\tthrows ";
  protected final String TEXT_8 = NL + "\t{" + NL + "\t\t";
  protected final String TEXT_9 = NL + "\t}" + NL + "\t" + NL;
  protected final String TEXT_10 = NL;

	public String generate(ITestCase testCase, final Helper helper)
  {
    final StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    
	class MethodBodyGenerator
	{
		public StringBuffer generate(ITestCase testCase)
		{
			StringBuffer sb = new StringBuffer();
			sb.append("// Enter your code here");
			return sb;
		}
	}

    
	MethodBodyGenerator methodBodyGenerator = new MethodBodyGenerator();
	String exceptionClassName = helper.getImportedName(Helper.EXCEPTION_CLASS_NAME);
	String code = methodBodyGenerator.generate(testCase).toString();
	String identifier = helper.getTestMethodName(testCase, false);

	if(identifier != null)
	{
		String description = testCase.getDescription();
		description = StringUtil.replace(description, NL, NL + " * ");	

    stringBuffer.append(TEXT_2);
    stringBuffer.append(testCase.getName());
    if(description != null){
    stringBuffer.append(TEXT_3);
    stringBuffer.append(description);
    stringBuffer.append(TEXT_4);
    }
    stringBuffer.append(TEXT_5);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_6);
    stringBuffer.append(identifier);
    stringBuffer.append(TEXT_7);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_8);
    stringBuffer.append(code);
    stringBuffer.append(TEXT_9);
    
	}

    stringBuffer.append(TEXT_10);
    
    return stringBuffer.toString();
  }
}
