/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.codegen;

import java.util.Iterator;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.ImportManager;
import org.eclipse.hyades.test.core.util.StringUtil;

class GenTestSuite
{
  protected static String nl;
  public static synchronized GenTestSuite create(String lineSeparator)
  {
    nl = lineSeparator;
    GenTestSuite result = new GenTestSuite();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "\t\t";
  protected final String TEXT_2 = NL + "package ";
  protected final String TEXT_3 = ";";
  protected final String TEXT_4 = NL;
  protected final String TEXT_5 = NL + NL + "/**" + NL + " * Generated code for the test suite <b>";
  protected final String TEXT_6 = "</b> located at" + NL + " * <i>";
  protected final String TEXT_7 = "</i>";
  protected final String TEXT_8 = ".";
  protected final String TEXT_9 = NL + " *" + NL + " * ";
  protected final String TEXT_10 = NL + " */" + NL + "public class ";
  protected final String TEXT_11 = NL + "extends ";
  protected final String TEXT_12 = NL + "{";
  protected final String TEXT_13 = NL;
  protected final String TEXT_14 = NL + "\t" + NL + "\t/**" + NL + "\t * @see junit.framework.TestCase#setUp()" + NL + "\t */" + NL + "\tprotected void setUp()" + NL + "\tthrows ";
  protected final String TEXT_15 = NL + "\t{" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * @see junit.framework.TestCase#tearDown()" + NL + "\t */" + NL + "\tprotected void tearDown()" + NL + "\tthrows ";
  protected final String TEXT_16 = NL + "\t{" + NL + "\t}\t";
  protected final String TEXT_17 = NL;
  protected final String TEXT_18 = NL + "}";
  protected final String TEXT_19 = NL;

	public String generate(ITestSuite testSuite, final Helper helper)
  {
    final StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    
	String packageName = helper.getPackageName(testSuite);
	String className = helper.retrieveClassName(testSuite);
	String description = testSuite.getDescription();
	if(description != null)
		description = StringUtil.replace(description.trim(), NL, NL + " * ");
	else
		description = "";
		
	helper.setImportManager(new ImportManager(packageName));
	helper.getImportedName(packageName + "." + className);

     if (!packageName.equals("")) { 
    stringBuffer.append(TEXT_2);
    stringBuffer.append(packageName);
    stringBuffer.append(TEXT_3);
     } 
    stringBuffer.append(TEXT_4);
    
	helper.addImport(helper.getSuperclassName());
	helper.markImportLocation(stringBuffer);

	final String superclassName = helper.getImportedName(helper.getSuperclassName());
	String exceptionClassName = helper.getImportedName(Helper.EXCEPTION_CLASS_NAME);
	String filePath = helper.getFilePath(testSuite);

    stringBuffer.append(TEXT_5);
    stringBuffer.append(testSuite.getName());
    if(filePath != null){
    stringBuffer.append(TEXT_6);
    stringBuffer.append(filePath);
    stringBuffer.append(TEXT_7);
    }
    stringBuffer.append(TEXT_8);
    if(description.length() > 0){
    stringBuffer.append(TEXT_9);
    stringBuffer.append(description);
    }
    stringBuffer.append(TEXT_10);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_11);
    stringBuffer.append(superclassName);
    stringBuffer.append(TEXT_12);
    
	GenTestSuiteConstructor constructorGenerator = new GenTestSuiteConstructor();
	stringBuffer.append(constructorGenerator.generate(className, helper));

    stringBuffer.append(TEXT_13);
    
	GenSuiteMethod suiteMethodGenerator = new GenSuiteMethod();
	stringBuffer.append(suiteMethodGenerator.generate(testSuite, helper));

    stringBuffer.append(TEXT_14);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_15);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_16);
    
	for(Iterator i=testSuite.getITestCases().iterator(); i.hasNext();)
	{
		ITestCase testCase = (ITestCase)i.next();
		GenTestMethod generator = new GenTestMethod();
		stringBuffer.append(generator.generate(testCase, helper));
	}

    stringBuffer.append(TEXT_17);
    stringBuffer.append(TEXT_18);
    helper.emitSortedImports();
    stringBuffer.append(TEXT_19);
    
    return stringBuffer.toString();
  }
}
