/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.codegen;

import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;

class GenTestSuiteConstructor
{
  protected static String nl;
  public static synchronized GenTestSuiteConstructor create(String lineSeparator)
  {
    nl = lineSeparator;
    GenTestSuiteConstructor result = new GenTestSuiteConstructor();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "\t\t";
  protected final String TEXT_2 = NL;
  protected final String TEXT_3 = "\t/**" + NL + "\t * Constructor for ";
  protected final String TEXT_4 = "." + NL + "\t * @param name" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_5 = "(String name)" + NL + "\t{" + NL + "\t\tsuper(name);" + NL + "\t}" + NL;

	public String generate(String className, final Helper helper)
  {
    final StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    stringBuffer.append(TEXT_2);
    stringBuffer.append(TEXT_3);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_4);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_5);
    
    return stringBuffer.toString();
  }
}
