/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitExecutionHistoryDefaultsProvider.java,v 1.3 2007/05/02 19:36:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.core.internal.launch.extensions.DefaultExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.tools.core.java.JUnitTestSuiteFacade;

public class JUnitExecutionHistoryDefaultsProvider extends DefaultExecutionHistoryDefaultsProvider {

	public IContainer getDefaultLocation(Object testElement) {
		if (testElement instanceof ITestSuite) {
			IFile file = JUnitTestSuiteFacade.getUnderlyingFile((ITestSuite)testElement);
			if (file != null) {
				return file.getProject();
			}
		}
		return null;
	}

}
