/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLjunitInvocationEventLoader.java,v 1.5 2007/05/02 19:36:27 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.loaders;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.common.ExecutionResultData;
import org.eclipse.hyades.loaders.common.XMLinvocationEventLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitModelUpdater;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class XMLjunitInvocationEventLoader extends XMLinvocationEventLoader {

	private String className;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.common.XMLinvocationEventLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		if ("className".equals(name)) { //$NON-NLS-1$
			className = value;
		} else {
			super.addAttribute(name, value);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.common.XMLinvocationEventLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Perform super actions
		super.addYourselfInContext();
		
		TPFTestSuite testSuite = null;
		boolean isLocal = false;
		if (className != null) {
			// First check if className matches the surrounding test (isLocal=true)
			// This is the most common situation, and determining that we are in this
			// situation avoid other time-consuming computations.
			TPFTest test = getReferencedTest();
			if (test != null && test instanceof TPFTestSuite) {
				IImplementor implementor = test.getImplementor();
				if (implementor != null) {
					if (className.equals(implementor.getResource())) {
						testSuite = (TPFTestSuite)test;
						isLocal = true;
					}
				}
			}
			if (!isLocal && test != null) {
				// Let's try to resolve className against an existing TPTP TestSuite
				// Locate the java file in the current project
				IJavaProject javaProject = getTestProject(test);
				if (javaProject != null) {
					testSuite = findTestSuite(className, javaProject, test.eResource().getResourceSet());
				}
			}
		}
		
		if (testSuite != null) {
			TPFTestCase testCase = findTestCase(testSuite);
			if (testCase != null) {
				// Replaces the execution data that was created by super (and associated
				// to the test returned by getReferencedTest()) by an execution result
				// associated to testCase.
				ExecutionResultData data = new ExecutionResultData(testCase, null);
				data.setInvocationEvent((TPFInvocationEvent)this.event);
				data.getResult(); // This instantiates the result
			}
		}
		if (!isLocal) {
			// Modify the name so the surrounding class name appears
			event.setName(this.name + " (" + this.className + ')'); //$NON-NLS-1$
		}
		// Copy the invocation name to the execution result name
		TPFExecutionResult executionResult = ((TPFInvocationEvent)event).getInvokedExecutionResult();
		if (executionResult != null) {
			executionResult.setName(event.getName());
		}
	}
	
	protected static TPFTestSuite findTestSuite(String className, IJavaProject javaProject, ResourceSet resourceSet) {
		try {
			IType type = javaProject.findType(className);
			if (type != null) {
				return JUnitModelUpdater.findTestSuite(type, resourceSet);
			}
			return null;
		} catch (JavaModelException e) {
			CorePlugin.logError(e);
			return null;
		}
		
	}
	
	protected TPFTestCase findTestCase(TPFTestSuite testSuite) {
		if (name == null) return null;
		Iterator it = testSuite.getTestCases().iterator();
		while (it.hasNext()) {
			TPFTestCase tc = (TPFTestCase) it.next();
			IImplementor implementor = tc.getImplementor();
			String methodName = null;
			if (implementor != null) {
				methodName = implementor.getResource();
			}
			if (name.equals(methodName)) {
				return tc;
			}
		}
		return null;
	}
	
	protected static IJavaProject getTestProject(TPFTest test) {
		IFile file = org.eclipse.hyades.test.core.util.EMFUtil.getWorkspaceFile(test);
		if (file != null) {
			IJavaProject javaProject = JavaCore.create(file.getProject());
			if (javaProject != null && javaProject.exists()) {
				return javaProject;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.common.XMLinvocationEventLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		this.className = null;
	}

}
