/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitResourceFactory.java,v 1.3 2007/05/02 19:36:27 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.modelsync;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.Resource.Factory;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.java.JUnitTestSuiteFacade;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;

public class JUnitResourceFactory implements Factory {

	public final static String PROTOCOL = "junit"; //$NON-NLS-1$
	
	public final static String ROOT_ID = "."; //$NON-NLS-1$
	
	public static URI getURI(ICompilationUnit cu, String type) {
		String[] segments = cu.getResource().getFullPath().segments();
		return URI.createHierarchicalURI(PROTOCOL, null, null, segments, type, null);
	}
	
	public Resource createResource(URI uri) {
		try {
			String type = uri.query();
			IPath path = new Path(uri.path());
			IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
			if (res != null && res.getType() == IResource.FILE) {
				ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)res);
				ITestSuite ts = JUnitTestSuiteFacade.createTestSuite(cu, type);
				if (ts != null && ts instanceof EObject) {
					return ((EObject)ts).eResource();
				}
			}
		} catch (Throwable t) {
			CorePlugin.logError(t);
		}
		return null;
	}

}
