/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitTestSuiteCreatedEvent.java,v 1.3 2007/05/02 19:36:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.modelsync.event;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;

/**
 * Event describing the creation of a JUnit test suite.
 * @author jcanches
 * @since 4.3
 */
public class JUnitTestSuiteCreatedEvent implements IJUnitTestSuiteFactoryEvent {
	
	private IFile sourceFile;
	private ITestSuite testSuite;
	private ICompilationUnit compilationUnit;

	public JUnitTestSuiteCreatedEvent(ITestSuite testSuite, IFile sourceFile) {
		this.testSuite = testSuite;
		this.sourceFile = sourceFile;
	}

	/**
	 * Returns the test suite that was created.
	 * @return The test suite that was created.
	 */
	public ITestSuite getTestSuite() {
		return this.testSuite;
	}
	
	/**
	 * Returns the compilation unit from which the test suite was generated.
	 * @return The compilation unit from which the test suite was generated.
	 */
	public ICompilationUnit getCompilationUnit() {
		if (compilationUnit == null) {
			compilationUnit = JavaCore.createCompilationUnitFrom(sourceFile);
		}
		return compilationUnit;
	}
	
}
