/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitTestSuiteDetachedEvent.java,v 1.3 2007/05/02 19:36:24 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.modelsync.event;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;

/**
 * Event describing the detachment of a JUnit class from its associated test suite.
 * A JUnit class becomes "detached" when its associated test suite model is either
 * deleted, or becomes associated to another JUnit class.
 * @author jcanches
 * @since 4.3
 */
public class JUnitTestSuiteDetachedEvent implements IJUnitTestSuiteFactoryEvent {

	private ICompilationUnit compilationUnit;
	private IFile sourceFile;

	public JUnitTestSuiteDetachedEvent(IFile sourceFile) {
		this.sourceFile = sourceFile;
	}

	/**
	 * Returns the compilation unit that is being detached.
	 * @return The compilation unit that is being detached.
	 */
	public ICompilationUnit getCompilationUnit() {
		if (compilationUnit == null) {
			compilationUnit = JavaCore.createCompilationUnitFrom(sourceFile);
		}
		return this.compilationUnit;
	}
	
}
