/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitTestSuiteFactoryEventManager.java,v 1.3 2007/05/02 19:36:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.modelsync.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.test.tools.core.CorePlugin;

/**
 * Utility class to register JUnitTestSuiteFactory listeners.
 * This class also dispatch events to the registered listeners.
 * @author jcanches
 * @since 4.3
 */
public class JUnitTestSuiteFactoryEventManager {

	private static JUnitTestSuiteFactoryEventManager instance;

	public static JUnitTestSuiteFactoryEventManager getInstance() {
		if (instance == null) {
			instance = new JUnitTestSuiteFactoryEventManager();
		}
		return instance;
	}
	
	private List listeners = new ArrayList(2);
	
	private JUnitTestSuiteFactoryEventManager() {
	}
	
	public void addListener(IJUnitTestSuiteFactoryListener listener) {
		listeners.add(listener);
	}
	
	public void removeListener(IJUnitTestSuiteFactoryListener listener) {
		listeners.remove(listener);
	}
	
	public void fireJUnitTestSuiteGenerated(IJUnitTestSuiteFactoryEvent event) {
		for (Iterator it = listeners.iterator(); it.hasNext();) {
			IJUnitTestSuiteFactoryListener listener = (IJUnitTestSuiteFactoryListener) it.next();
			try {
				listener.onEvent(event);
			} catch (Throwable t) {
				CorePlugin.logError(t);
			}
		}
	}
	
}
