/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DynamicVariableResolver.java,v 1.3 2007/05/02 19:36:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.preferences;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.jdt.core.ICompilationUnit;

public class DynamicVariableResolver implements IDynamicVariableResolver {

	public final static String CLASS_NAME = "tptp_junit_type_name"; //$NON-NLS-1$
	public final static String CONTAINER_PATH = "tptp_junit_container_path"; //$NON-NLS-1$
	public final static String PROJECT_NAME = "tptp_junit_project"; //$NON-NLS-1$
	
	private static ICompilationUnit currentCu;
	
	public static void setCurrentCompilationUnit(ICompilationUnit cu) {
		currentCu = cu;
	}
	
	public static void unsetCurrentCompilationUnit() {
		currentCu = null;
	}
	
	public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
		if (currentCu == null) return ""; //$NON-NLS-1$
		if (CLASS_NAME.equals(variable.getName())) {
			return currentCu.findPrimaryType().getElementName();
		}
		if (CONTAINER_PATH.equals(variable.getName())) {
			return currentCu.getResource().getParent().getFullPath().toPortableString();
		}
		if (PROJECT_NAME.equals(variable.getName())) {
			return currentCu.getResource().getProject().getName();
		}
		return null;
	}

}
